/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.guice;

import com.github.zhengframework.guice.TypePostProcessor;
import com.github.zhengframework.guice.Utils;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;

public class GeneralTypeListener<T>
implements TypeListener {
    private final Class<T> typeClass;
    private final TypePostProcessor<T> postProcessor;

    public GeneralTypeListener(Class<T> typeClass, TypePostProcessor<T> postProcessor) {
        this.typeClass = typeClass;
        this.postProcessor = postProcessor;
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        Class actualType = type.getRawType();
        if (!Utils.isPackageValid(actualType)) {
            return;
        }
        if (this.typeClass.isAssignableFrom(actualType)) {
            encounter.register(new InjectionListener<I>(){

                public void afterInjection(I injectee) {
                    try {
                        GeneralTypeListener.this.postProcessor.process(injectee);
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException(String.format("Failed to process type %s of class %s", GeneralTypeListener.this.typeClass.getSimpleName(), injectee.getClass().getSimpleName()), ex);
                    }
                }
            });
        }
    }
}

