/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.configuration;

import com.github.zhengframework.configuration.ValueFunctions;
import com.github.zhengframework.configuration.parser.Parser;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface Configuration {
    public Optional<String> get(String var1);

    public Set<String> keySet();

    public Map<String, String> asMap();

    public Configuration prefix(String var1);

    public List<Configuration> prefixList(String var1);

    public Set<Configuration> prefixSet(String var1);

    public Map<String, Configuration> prefixMap(String var1);

    default public Optional<String> getString(String key) {
        return this.get(key);
    }

    default public String getString(String key, String defaultValue) {
        return this.getString(key).orElse(defaultValue);
    }

    default public Optional<Integer> getInt(String key) {
        return this.getValue(key, Integer::parseInt);
    }

    default public Integer getInt(String key, Integer defaultValue) {
        return this.getInt(key).orElse(defaultValue);
    }

    default public Optional<Charset> getCharset(String key) {
        return this.getValue(key, Charset::forName);
    }

    default public Charset getCharset(String key, Charset defaultValue) {
        return this.getCharset(key).orElse(defaultValue);
    }

    default public Optional<Long> getLong(String key) {
        return this.getValue(key, Long::parseLong);
    }

    default public Long getLong(String key, Long defaultValue) {
        return this.getLong(key).orElse(defaultValue);
    }

    default public Optional<Float> getFloat(String key) {
        return this.getValue(key, Float::parseFloat);
    }

    default public Float getFloat(String key, Float defaultValue) {
        return this.getFloat(key).orElse(defaultValue);
    }

    default public Optional<Double> getDouble(String key) {
        return this.getValue(key, Double::parseDouble);
    }

    default public Double getDouble(String key, Double defaultValue) {
        return this.getDouble(key).orElse(defaultValue);
    }

    default public Optional<Boolean> getBoolean(String key) {
        return this.getValue(key, s -> ValueFunctions.toBoolean().parse((String)s));
    }

    default public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.getBoolean(key).orElse(defaultValue);
    }

    default public Optional<BigDecimal> getBigDecimal(String key) {
        return this.getValue(key, BigDecimal::new);
    }

    default public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.getBigDecimal(key).orElse(defaultValue);
    }

    default public Optional<BigInteger> getBigInteger(String key) {
        return this.getValue(key, BigInteger::new);
    }

    default public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.getBigInteger(key).orElse(defaultValue);
    }

    default public Optional<File> getFile(String key) {
        return this.getValue(key, File::new);
    }

    default public File getFile(String key, File defaultValue) {
        return this.getFile(key).orElse(defaultValue);
    }

    default public Optional<Path> getPath(String key) {
        return this.getValue(key, x$0 -> Paths.get(x$0, new String[0]));
    }

    default public Path getPath(String key, Path defaultValue) {
        return this.getPath(key).orElse(defaultValue);
    }

    default public Optional<Calendar> getCalendar(String key) {
        return this.getValue(key, s -> ValueFunctions.toCalendar().parse((String)s));
    }

    default public Calendar getCalendar(String key, Calendar defaultValue) {
        return this.getCalendar(key).orElse(defaultValue);
    }

    default public Optional<LocalTime> getLocalTime(String key) {
        return this.getValue(key, LocalTime::parse);
    }

    default public LocalTime getLocalTime(String key, LocalTime defaultValue) {
        return this.getLocalTime(key).orElse(defaultValue);
    }

    default public Optional<LocalDateTime> getLocalDateTime(String key) {
        return this.getValue(key, LocalDateTime::parse);
    }

    default public LocalDateTime getLocalDateTime(String key, LocalDateTime defaultValue) {
        return this.getLocalDateTime(key).orElse(defaultValue);
    }

    default public Optional<LocalDate> getLocalDate(String key) {
        return this.getValue(key, LocalDate::parse);
    }

    default public LocalDate getLocalDate(String key, LocalDate defaultValue) {
        return this.getLocalDate(key).orElse(defaultValue);
    }

    default public Optional<URI> getURI(String key) {
        return this.getValue(key, s -> ValueFunctions.toURI().parse((String)s));
    }

    default public URI getURI(String key, URI defaultValue) {
        return this.getURI(key).orElse(defaultValue);
    }

    default public Optional<URL> getURL(String key) {
        return this.getValue(key, s -> ValueFunctions.toURL().parse((String)s));
    }

    default public URL getURL(String key, URL defaultValue) {
        return this.getURL(key).orElse(defaultValue);
    }

    default public <T extends Enum<T>> Optional<T> getEnum(String key, Class<T> enumType) {
        return this.getValue(key, s -> Enum.valueOf(enumType, s));
    }

    default public <T extends Enum<T>> T getEnum(String key, Class<T> enumType, T defaultValue) {
        return (T)((Enum)this.getEnum(key, enumType).orElse(defaultValue));
    }

    default public <T> Optional<T> getValue(String key, Function<String, T> func) {
        return this.get(key).map(func);
    }

    default public <T> T getValue(String key, Function<String, T> func, T defaultValue) {
        return this.get(key).map(func).orElse(defaultValue);
    }

    default public Optional<String[]> getArray(String key) {
        return this.getArray(key, ",");
    }

    default public String[] getArray(String key, String[] defaultValue) {
        return this.getArray(key, ",").orElse(defaultValue);
    }

    default public Optional<String[]> getArray(String key, String separator) {
        return this.get(key).map(s -> ValueFunctions.toArray(separator).parse((String)s));
    }

    default public String[] getArray(String key, String separator, String[] defaultValue) {
        return this.getArray(key, separator).orElse(defaultValue);
    }

    default public List<String> getList(String key, String separator, List<String> defaultValue) {
        return this.get(key).map(s -> ValueFunctions.toList(separator).parse((String)s)).orElse(defaultValue);
    }

    default public Optional<List<String>> getList(String key, String separator) {
        return this.get(key).map(s -> ValueFunctions.toList(separator).parse((String)s));
    }

    default public Optional<List<String>> getList(String key) {
        return this.get(key).map(s -> ValueFunctions.toList(",").parse((String)s));
    }

    default public List<String> getList(String key, List<String> defaultValue) {
        return this.get(key).map(s -> ValueFunctions.toList(",").parse((String)s)).orElse(defaultValue);
    }

    default public <T> List<T> getList(String key, String separator, Parser<T> map) {
        return this.getList(key, separator).orElse(Collections.emptyList()).stream().map(map::parse).collect(Collectors.toList());
    }

    default public <T> T[] getArray(String key, String separator, Parser<T> map) {
        return Arrays.stream((Object[])this.getArray(key, separator).orElse(new String[0])).map(map::parse).toArray();
    }

    default public <T> List<T> getList(String key, Parser<T> map) {
        return this.getList(key, ",").orElse(Collections.emptyList()).stream().map(map::parse).collect(Collectors.toList());
    }

    default public <T> T[] getArray(String key, Parser<T> map) {
        return Arrays.stream((Object[])this.getArray(key, ",").orElse(new String[0])).map(map::parse).toArray();
    }
}

