/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.guice;

import com.github.zhengframework.guice.FieldPostProcessor;
import com.github.zhengframework.guice.Utils;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class AnnotatedFieldTypeListener<T extends Annotation>
implements TypeListener {
    private final Class<T> annotationClass;
    private final FieldPostProcessor<T> postProcessor;

    public AnnotatedFieldTypeListener(Class<T> annotationClass, FieldPostProcessor<T> postProcessor) {
        this.annotationClass = annotationClass;
        this.postProcessor = postProcessor;
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        Class actualType = type.getRawType();
        if (!Utils.isPackageValid(actualType)) {
            return;
        }
        for (Class investigatingType = actualType; investigatingType != null && !investigatingType.equals(Object.class); investigatingType = investigatingType.getSuperclass()) {
            for (Field field : investigatingType.getDeclaredFields()) {
                if (!field.isAnnotationPresent(this.annotationClass)) continue;
                encounter.register(injected -> {
                    try {
                        field.setAccessible(true);
                        this.postProcessor.process(field.getAnnotation(this.annotationClass), field, injected);
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException(String.format("Failed to process annotation %s of field %s of class %s", this.annotationClass.getSimpleName(), field.getName(), injected.getClass().getSimpleName()), ex);
                    }
                });
            }
        }
    }
}

