/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.service;

import com.github.zhengframework.service.Service;
import com.github.zhengframework.service.ServiceClassScanner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ServiceManager {
    private static final Logger log = LoggerFactory.getLogger(ServiceManager.class);
    private List<Service> services;
    private boolean starting = false;
    private boolean stopping = false;

    @Inject
    public ServiceManager(ServiceClassScanner serviceClassScanner) {
        ArrayList<Service> copyList = new ArrayList<Service>();
        serviceClassScanner.accept(copyList::add);
        copyList.sort(Comparator.comparing(Service::order).reversed());
        this.services = ImmutableList.copyOf(copyList);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                log.info("stop by ShutdownHook");
                ServiceManager.this.stop();
            }
        });
    }

    public void start() throws Exception {
        if (!this.starting) {
            for (Service service : this.services) {
                try {
                    log.info("start service[{}]", service.getClass());
                    service.start();
                }
                catch (Exception e) {
                    log.error("start service[{}] fail", service.getClass(), (Object)e);
                }
            }
            this.starting = true;
        }
    }

    public void stop() {
        if (!this.stopping) {
            this.stopping = true;
            for (Service service : this.services) {
                try {
                    log.info("stop service[{}]", service.getClass());
                    service.stop();
                }
                catch (Exception e) {
                    log.error("fail stop service[{}]", service.getClass(), (Object)e);
                }
            }
        }
    }
}

