/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.jdbc;

import com.github.zhengframework.configuration.ConfigurationDefine;
import com.github.zhengframework.configuration.annotation.ConfigurationInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@ConfigurationInfo(prefix="zheng.dataSource", supportGroup=true)
public class DataSourceConfig
implements ConfigurationDefine {
    private String catalog;
    private long connectionTimeout = TimeUnit.SECONDS.toMillis(30L);
    private long validationTimeout = TimeUnit.SECONDS.toMillis(5L);
    private long idleTimeout = TimeUnit.MINUTES.toMillis(10L);
    private long leakDetectionThreshold;
    private long maxLifetime = TimeUnit.MINUTES.toMillis(30L);
    private int maxPoolSize = -1;
    private int minIdle = -1;
    private String username;
    private String password;
    private long initializationFailTimeout = 1L;
    private String connectionInitSql;
    private String connectionTestQuery;
    private String dataSourceClassName;
    private String dataSourceJndiName;
    private String driverClassName;
    private String jdbcUrl;
    private String poolName;
    private String schema;
    private String transactionIsolationName;
    private boolean isAutoCommit = true;
    private boolean isReadOnly = false;
    private Map<String, String> properties = new HashMap<String, String>();

    public String getCatalog() {
        return this.catalog;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public long getValidationTimeout() {
        return this.validationTimeout;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public long getLeakDetectionThreshold() {
        return this.leakDetectionThreshold;
    }

    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public long getInitializationFailTimeout() {
        return this.initializationFailTimeout;
    }

    public String getConnectionInitSql() {
        return this.connectionInitSql;
    }

    public String getConnectionTestQuery() {
        return this.connectionTestQuery;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTransactionIsolationName() {
        return this.transactionIsolationName;
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setValidationTimeout(long validationTimeout) {
        this.validationTimeout = validationTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setLeakDetectionThreshold(long leakDetectionThreshold) {
        this.leakDetectionThreshold = leakDetectionThreshold;
    }

    public void setMaxLifetime(long maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setInitializationFailTimeout(long initializationFailTimeout) {
        this.initializationFailTimeout = initializationFailTimeout;
    }

    public void setConnectionInitSql(String connectionInitSql) {
        this.connectionInitSql = connectionInitSql;
    }

    public void setConnectionTestQuery(String connectionTestQuery) {
        this.connectionTestQuery = connectionTestQuery;
    }

    public void setDataSourceClassName(String dataSourceClassName) {
        this.dataSourceClassName = dataSourceClassName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTransactionIsolationName(String transactionIsolationName) {
        this.transactionIsolationName = transactionIsolationName;
    }

    public void setAutoCommit(boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceConfig)) {
            return false;
        }
        DataSourceConfig other = (DataSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$catalog = this.getCatalog();
        String other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getValidationTimeout() != other.getValidationTimeout()) {
            return false;
        }
        if (this.getIdleTimeout() != other.getIdleTimeout()) {
            return false;
        }
        if (this.getLeakDetectionThreshold() != other.getLeakDetectionThreshold()) {
            return false;
        }
        if (this.getMaxLifetime() != other.getMaxLifetime()) {
            return false;
        }
        if (this.getMaxPoolSize() != other.getMaxPoolSize()) {
            return false;
        }
        if (this.getMinIdle() != other.getMinIdle()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        if (this.getInitializationFailTimeout() != other.getInitializationFailTimeout()) {
            return false;
        }
        String this$connectionInitSql = this.getConnectionInitSql();
        String other$connectionInitSql = other.getConnectionInitSql();
        if (this$connectionInitSql == null ? other$connectionInitSql != null : !this$connectionInitSql.equals(other$connectionInitSql)) {
            return false;
        }
        String this$connectionTestQuery = this.getConnectionTestQuery();
        String other$connectionTestQuery = other.getConnectionTestQuery();
        if (this$connectionTestQuery == null ? other$connectionTestQuery != null : !this$connectionTestQuery.equals(other$connectionTestQuery)) {
            return false;
        }
        String this$dataSourceClassName = this.getDataSourceClassName();
        String other$dataSourceClassName = other.getDataSourceClassName();
        if (this$dataSourceClassName == null ? other$dataSourceClassName != null : !this$dataSourceClassName.equals(other$dataSourceClassName)) {
            return false;
        }
        String this$dataSourceJndiName = this.getDataSourceJndiName();
        String other$dataSourceJndiName = other.getDataSourceJndiName();
        if (this$dataSourceJndiName == null ? other$dataSourceJndiName != null : !this$dataSourceJndiName.equals(other$dataSourceJndiName)) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$poolName = this.getPoolName();
        String other$poolName = other.getPoolName();
        if (this$poolName == null ? other$poolName != null : !this$poolName.equals(other$poolName)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$transactionIsolationName = this.getTransactionIsolationName();
        String other$transactionIsolationName = other.getTransactionIsolationName();
        if (this$transactionIsolationName == null ? other$transactionIsolationName != null : !this$transactionIsolationName.equals(other$transactionIsolationName)) {
            return false;
        }
        if (this.isAutoCommit() != other.isAutoCommit()) {
            return false;
        }
        if (this.isReadOnly() != other.isReadOnly()) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        long $connectionTimeout = this.getConnectionTimeout();
        result = result * 59 + (int)($connectionTimeout >>> 32 ^ $connectionTimeout);
        long $validationTimeout = this.getValidationTimeout();
        result = result * 59 + (int)($validationTimeout >>> 32 ^ $validationTimeout);
        long $idleTimeout = this.getIdleTimeout();
        result = result * 59 + (int)($idleTimeout >>> 32 ^ $idleTimeout);
        long $leakDetectionThreshold = this.getLeakDetectionThreshold();
        result = result * 59 + (int)($leakDetectionThreshold >>> 32 ^ $leakDetectionThreshold);
        long $maxLifetime = this.getMaxLifetime();
        result = result * 59 + (int)($maxLifetime >>> 32 ^ $maxLifetime);
        result = result * 59 + this.getMaxPoolSize();
        result = result * 59 + this.getMinIdle();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        long $initializationFailTimeout = this.getInitializationFailTimeout();
        result = result * 59 + (int)($initializationFailTimeout >>> 32 ^ $initializationFailTimeout);
        String $connectionInitSql = this.getConnectionInitSql();
        result = result * 59 + ($connectionInitSql == null ? 43 : $connectionInitSql.hashCode());
        String $connectionTestQuery = this.getConnectionTestQuery();
        result = result * 59 + ($connectionTestQuery == null ? 43 : $connectionTestQuery.hashCode());
        String $dataSourceClassName = this.getDataSourceClassName();
        result = result * 59 + ($dataSourceClassName == null ? 43 : $dataSourceClassName.hashCode());
        String $dataSourceJndiName = this.getDataSourceJndiName();
        result = result * 59 + ($dataSourceJndiName == null ? 43 : $dataSourceJndiName.hashCode());
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $poolName = this.getPoolName();
        result = result * 59 + ($poolName == null ? 43 : $poolName.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $transactionIsolationName = this.getTransactionIsolationName();
        result = result * 59 + ($transactionIsolationName == null ? 43 : $transactionIsolationName.hashCode());
        result = result * 59 + (this.isAutoCommit() ? 79 : 97);
        result = result * 59 + (this.isReadOnly() ? 79 : 97);
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "DataSourceConfig(catalog=" + this.getCatalog() + ", connectionTimeout=" + this.getConnectionTimeout() + ", validationTimeout=" + this.getValidationTimeout() + ", idleTimeout=" + this.getIdleTimeout() + ", leakDetectionThreshold=" + this.getLeakDetectionThreshold() + ", maxLifetime=" + this.getMaxLifetime() + ", maxPoolSize=" + this.getMaxPoolSize() + ", minIdle=" + this.getMinIdle() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", initializationFailTimeout=" + this.getInitializationFailTimeout() + ", connectionInitSql=" + this.getConnectionInitSql() + ", connectionTestQuery=" + this.getConnectionTestQuery() + ", dataSourceClassName=" + this.getDataSourceClassName() + ", dataSourceJndiName=" + this.getDataSourceJndiName() + ", driverClassName=" + this.getDriverClassName() + ", jdbcUrl=" + this.getJdbcUrl() + ", poolName=" + this.getPoolName() + ", schema=" + this.getSchema() + ", transactionIsolationName=" + this.getTransactionIsolationName() + ", isAutoCommit=" + this.isAutoCommit() + ", isReadOnly=" + this.isReadOnly() + ", properties=" + this.getProperties() + ")";
    }
}

