/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.jdbc;

import com.github.zhengframework.configuration.Configuration;
import com.github.zhengframework.configuration.ConfigurationAware;
import com.github.zhengframework.configuration.ConfigurationBeanMapper;
import com.github.zhengframework.jdbc.DataSourceConfig;
import com.github.zhengframework.jdbc.DataSourceProvider;
import com.github.zhengframework.jdbc.DataSourceProxy;
import com.github.zhengframework.jdbc.ManagedSchema;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.name.Names;
import com.zaxxer.hikari.HikariConfig;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceModule
extends AbstractModule
implements ConfigurationAware {
    private static final Logger log = LoggerFactory.getLogger(DataSourceModule.class);
    private Configuration configuration;

    protected void configure() {
        Provider injectorProvider = this.getProvider(Injector.class);
        Preconditions.checkArgument((this.configuration != null ? 1 : 0) != 0, (Object)"configuration is null");
        Map dataSourceConfigMap = ConfigurationBeanMapper.resolve((Configuration)this.configuration, DataSourceConfig.class);
        for (Map.Entry entry : dataSourceConfigMap.entrySet()) {
            String name = (String)entry.getKey();
            DataSourceConfig dataSourceConfig = (DataSourceConfig)entry.getValue();
            HikariConfig config = this.getHikariConfig(dataSourceConfig);
            if (name.isEmpty()) {
                this.bind(HikariConfig.class).toInstance((Object)config);
                this.bind(DataSource.class).toProvider((javax.inject.Provider)new DataSourceProvider(config, (javax.inject.Provider<Injector>)injectorProvider, null)).in(Singleton.class);
                Multibinder.newSetBinder((Binder)this.binder(), DataSourceProxy.class).addBinding().toInstance(dataSource -> dataSource);
                OptionalBinder.newOptionalBinder((Binder)this.binder(), ManagedSchema.class).setDefault().toInstance(dataSource -> {});
                continue;
            }
            this.bind(Key.get(HikariConfig.class, (Annotation)Names.named((String)name))).toInstance((Object)config);
            this.bind(Key.get(DataSource.class, (Annotation)Names.named((String)name))).toProvider((javax.inject.Provider)new DataSourceProvider(config, (javax.inject.Provider<Injector>)injectorProvider, (Annotation)Names.named((String)name))).in(Singleton.class);
            Multibinder.newSetBinder((Binder)this.binder(), (Key)Key.get(DataSourceProxy.class, (Annotation)Names.named((String)name))).addBinding().toInstance(dataSource -> dataSource);
            OptionalBinder.newOptionalBinder((Binder)this.binder(), (Key)Key.get(ManagedSchema.class, (Annotation)Names.named((String)name))).setDefault().toInstance(dataSource -> {});
        }
    }

    private HikariConfig getHikariConfig(DataSourceConfig dataSourceConfig) {
        HikariConfig config = new HikariConfig();
        if (!Strings.isNullOrEmpty((String)dataSourceConfig.getDriverClassName())) {
            config.setDriverClassName(dataSourceConfig.getDriverClassName());
        }
        if (!Strings.isNullOrEmpty((String)dataSourceConfig.getJdbcUrl())) {
            config.setJdbcUrl(dataSourceConfig.getJdbcUrl());
        }
        if (!Strings.isNullOrEmpty((String)dataSourceConfig.getUsername())) {
            config.setUsername(dataSourceConfig.getUsername());
        }
        if (!Strings.isNullOrEmpty((String)dataSourceConfig.getPassword())) {
            config.setPassword(dataSourceConfig.getPassword());
        }
        if (!Strings.isNullOrEmpty((String)dataSourceConfig.getCatalog())) {
            config.setCatalog(dataSourceConfig.getCatalog());
        }
        if (!Strings.isNullOrEmpty((String)dataSourceConfig.getConnectionInitSql())) {
            config.setConnectionInitSql(dataSourceConfig.getConnectionInitSql());
        }
        if (!Strings.isNullOrEmpty((String)dataSourceConfig.getConnectionTestQuery())) {
            config.setConnectionTestQuery(dataSourceConfig.getConnectionTestQuery());
        }
        if (!Strings.isNullOrEmpty((String)dataSourceConfig.getDataSourceClassName())) {
            config.setDataSourceClassName(dataSourceConfig.getDataSourceClassName());
        }
        if (!Strings.isNullOrEmpty((String)dataSourceConfig.getDataSourceJndiName())) {
            config.setDataSourceJNDI(dataSourceConfig.getDataSourceJndiName());
        }
        config.setAutoCommit(dataSourceConfig.isAutoCommit());
        config.setConnectionTimeout(dataSourceConfig.getConnectionTimeout());
        config.setIdleTimeout(dataSourceConfig.getIdleTimeout());
        config.setInitializationFailTimeout(dataSourceConfig.getInitializationFailTimeout());
        config.setLeakDetectionThreshold(dataSourceConfig.getLeakDetectionThreshold());
        if (dataSourceConfig.getMaxPoolSize() > 1) {
            config.setMaximumPoolSize(dataSourceConfig.getMaxPoolSize());
        }
        if (dataSourceConfig.getMaxLifetime() > 1L) {
            config.setMaxLifetime(dataSourceConfig.getMaxLifetime());
        }
        if (dataSourceConfig.getMinIdle() > 1) {
            config.setMinimumIdle(dataSourceConfig.getMinIdle());
        }
        if (!Strings.isNullOrEmpty((String)dataSourceConfig.getPoolName())) {
            config.setPoolName(dataSourceConfig.getPoolName());
        }
        if (!Strings.isNullOrEmpty((String)dataSourceConfig.getSchema())) {
            config.setSchema(dataSourceConfig.getSchema());
        }
        if (!Strings.isNullOrEmpty((String)dataSourceConfig.getDataSourceJndiName())) {
            config.setDataSourceJNDI(dataSourceConfig.getDataSourceJndiName());
        }
        config.setReadOnly(dataSourceConfig.isReadOnly());
        config.setValidationTimeout(dataSourceConfig.getValidationTimeout());
        for (Map.Entry<String, String> entry : dataSourceConfig.getProperties().entrySet()) {
            config.addDataSourceProperty(entry.getKey(), (Object)entry.getValue());
        }
        return config;
    }

    public void initConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourceModule)) {
            return false;
        }
        DataSourceModule other = (DataSourceModule)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Configuration this$configuration = this.configuration;
        Configuration other$configuration = other.configuration;
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSourceModule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Configuration $configuration = this.configuration;
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

