/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.jdbc;

import com.github.zhengframework.jdbc.DataSourceProxy;
import com.github.zhengframework.jdbc.ManagedSchema;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceProvider
implements Provider<DataSource> {
    private static final Logger log = LoggerFactory.getLogger(DataSourceProvider.class);
    private HikariConfig config;
    private Provider<Injector> injectorProvider;
    private Annotation annotation;

    @Inject
    public DataSourceProvider(HikariConfig config, Provider<Injector> injectorProvider, Annotation annotation) {
        this.config = config;
        this.injectorProvider = injectorProvider;
        this.annotation = annotation;
    }

    public DataSource get() {
        Injector injector = (Injector)this.injectorProvider.get();
        Set dataSourceProxySet = this.annotation == null ? (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<DataSourceProxy>>(){})) : (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<DataSourceProxy>>(){}, (Annotation)this.annotation));
        Object dataSource = new HikariDataSource(this.config);
        List collect = dataSourceProxySet.stream().sorted(Comparator.comparing(DataSourceProxy::priority)).collect(Collectors.toList());
        for (DataSourceProxy dataSourceProxy : collect) {
            dataSource = (DataSource)dataSourceProxy.apply(dataSource);
        }
        ManagedSchema managedSchema = this.annotation == null ? (ManagedSchema)injector.getInstance(Key.get(ManagedSchema.class)) : (ManagedSchema)injector.getInstance(Key.get(ManagedSchema.class, (Annotation)this.annotation));
        log.info("managedSchema={}", managedSchema.getClass());
        managedSchema.migrate((DataSource)dataSource);
        return dataSource;
    }
}

