/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.mybatis;

import com.github.zhengframework.configuration.Configuration;
import com.github.zhengframework.configuration.ConfigurationAwareModule;
import com.github.zhengframework.configuration.ConfigurationBeanMapper;
import com.github.zhengframework.guice.ExposedPrivateModule;
import com.github.zhengframework.mybatis.MyBatisConfig;
import com.github.zhengframework.mybatis.MyBatisInternalModule;
import com.google.inject.Key;
import com.google.inject.Module;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisModule
extends ConfigurationAwareModule {
    private static final Logger log = LoggerFactory.getLogger(MyBatisModule.class);

    protected void configure() {
        Map myBatisConfigMap = ConfigurationBeanMapper.resolve((Configuration)this.getConfiguration(), MyBatisConfig.class);
        MyBatisConfig myBatisConfig = (MyBatisConfig)myBatisConfigMap.get("");
        this.requireBinding(Key.get(DataSource.class));
        this.install((Module)new MyBatisInternalModule(myBatisConfig));
        Class<? extends ExposedPrivateModule> extraModuleClass = myBatisConfig.getExtraModuleClass();
        if (extraModuleClass != null) {
            try {
                ExposedPrivateModule module = extraModuleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                log.info("install extra module: " + extraModuleClass.getName());
                this.install((Module)module);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

