/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.mybatis;

import com.github.zhengframework.guice.ExposedPrivateModule;
import com.github.zhengframework.mybatis.MyBatisConfig;
import com.github.zhengframework.mybatis.MyBatisInternalModule;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisPrivateModule
extends PrivateModule {
    private static final Logger log = LoggerFactory.getLogger(MyBatisPrivateModule.class);
    private final Annotation qualifier;
    private final MyBatisConfig myBatisConfig;

    public MyBatisPrivateModule(Annotation qualifier, MyBatisConfig myBatisConfig) {
        this.qualifier = qualifier;
        this.myBatisConfig = myBatisConfig;
        log.info("qualifier={}", (Object)qualifier);
    }

    protected void configure() {
        if (this.qualifier != null) {
            this.bind(DataSource.class).toProvider(this.getProvider(Key.get(DataSource.class, (Annotation)this.qualifier)));
        }
        this.install((Module)new MyBatisInternalModule(this.myBatisConfig));
        Class<? extends ExposedPrivateModule> extraModuleClass = this.myBatisConfig.getExtraModuleClass();
        if (extraModuleClass != null) {
            try {
                ExposedPrivateModule module = extraModuleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                log.info("install module: " + extraModuleClass.getName());
                this.install((Module)module);
                for (Key key : module.getExposeList()) {
                    this.exposeClass(key);
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void exposeClass(Key key) {
        if (this.qualifier != null) {
            this.bind(key.getTypeLiteral()).annotatedWith(this.qualifier).toProvider(this.binder().getProvider(key));
            this.expose(key.getTypeLiteral()).annotatedWith(this.qualifier);
        } else {
            this.expose(key.getTypeLiteral());
        }
    }
}

