/*
 * Decompiled with CFR 0.152.
 */
package com.github.zomin.aspect;

import com.github.zomin.annotation.CacheEvict;
import com.github.zomin.annotation.CachePut;
import com.github.zomin.annotation.Cacheable;
import com.github.zomin.annotation.FirstCache;
import com.github.zomin.annotation.SecondaryCache;
import com.github.zomin.cache.Cache;
import com.github.zomin.expression.CacheOperationExpressionEvaluator;
import com.github.zomin.manager.CacheManager;
import com.github.zomin.setting.FirstCacheSetting;
import com.github.zomin.setting.LayeringCacheSetting;
import com.github.zomin.setting.SecondaryCacheSetting;
import com.github.zomin.support.CacheOperationInvoker;
import com.github.zomin.support.KeyGenerator;
import com.github.zomin.support.SerializationException;
import com.github.zomin.support.SimpleKeyGenerator;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Aspect
public class LayeringAspect {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String CACHE_KEY_ERROR_MESSAGE = "\u7f13\u5b58Key %s \u4e0d\u80fd\u4e3aNULL";
    private static final String CACHE_NAME_ERROR_MESSAGE = "\u7f13\u5b58\u540d\u79f0\u4e0d\u80fd\u4e3aNULL";
    private final CacheOperationExpressionEvaluator evaluator = new CacheOperationExpressionEvaluator();
    @Autowired
    private CacheManager cacheManager;
    @Autowired(required=false)
    private KeyGenerator keyGenerator = new SimpleKeyGenerator();

    @Pointcut(value="@annotation(com.github.zomin.annotation.Cacheable)")
    public void cacheablePointcut() {
    }

    @Pointcut(value="@annotation(com.github.zomin.annotation.CacheEvict)")
    public void cacheEvictPointcut() {
    }

    @Pointcut(value="@annotation(com.github.zomin.annotation.CachePut)")
    public void cachePutPointcut() {
    }

    @Around(value="cacheablePointcut()")
    public Object cacheablePointcut(ProceedingJoinPoint joinPoint) throws Throwable {
        CacheOperationInvoker aopAllianceInvoker = this.getCacheOperationInvoker(joinPoint);
        Method method = this.getSpecificmethod(joinPoint);
        Cacheable cacheable = (Cacheable)AnnotationUtils.findAnnotation((Method)method, Cacheable.class);
        try {
            return this.executeCacheable(aopAllianceInvoker, cacheable, method, joinPoint.getArgs(), joinPoint.getTarget());
        }
        catch (SerializationException e) {
            String[] cacheNames = cacheable.cacheNames();
            this.delete(cacheNames, cacheable.key(), method, joinPoint.getArgs(), joinPoint.getTarget());
            if (cacheable.ignoreException()) {
                this.logger.warn(e.getMessage(), (Throwable)e);
                return aopAllianceInvoker.invoke();
            }
            throw e;
        }
        catch (Exception e) {
            if (cacheable.ignoreException()) {
                this.logger.warn(e.getMessage(), (Throwable)e);
                return aopAllianceInvoker.invoke();
            }
            throw e;
        }
    }

    @Around(value="cacheEvictPointcut()")
    public Object cacheEvictPointcut(ProceedingJoinPoint joinPoint) throws Throwable {
        CacheOperationInvoker aopAllianceInvoker = this.getCacheOperationInvoker(joinPoint);
        Method method = this.getSpecificmethod(joinPoint);
        CacheEvict cacheEvict = (CacheEvict)AnnotationUtils.findAnnotation((Method)method, CacheEvict.class);
        try {
            return this.executeEvict(aopAllianceInvoker, cacheEvict, method, joinPoint.getArgs(), joinPoint.getTarget());
        }
        catch (Exception e) {
            if (cacheEvict.ignoreException()) {
                this.logger.warn(e.getMessage(), (Throwable)e);
                return aopAllianceInvoker.invoke();
            }
            throw e;
        }
    }

    @Around(value="cachePutPointcut()")
    public Object cachePutPointcut(ProceedingJoinPoint joinPoint) throws Throwable {
        CacheOperationInvoker aopAllianceInvoker = this.getCacheOperationInvoker(joinPoint);
        Method method = this.getSpecificmethod(joinPoint);
        CachePut cacheEvict = (CachePut)AnnotationUtils.findAnnotation((Method)method, CachePut.class);
        try {
            return this.executePut(aopAllianceInvoker, cacheEvict, method, joinPoint.getArgs(), joinPoint.getTarget());
        }
        catch (Exception e) {
            if (cacheEvict.ignoreException()) {
                this.logger.warn(e.getMessage(), (Throwable)e);
                return aopAllianceInvoker.invoke();
            }
            throw e;
        }
    }

    private Object executeCacheable(CacheOperationInvoker invoker, Cacheable cacheable, Method method, Object[] args, Object target) {
        String[] cacheNames = cacheable.cacheNames();
        Assert.notEmpty((Object[])cacheable.cacheNames(), (String)CACHE_NAME_ERROR_MESSAGE);
        String cacheName = cacheNames[0];
        Object key = this.generateKey(cacheable.key(), method, args, target);
        Assert.notNull((Object)key, (String)String.format(CACHE_KEY_ERROR_MESSAGE, cacheable.key()));
        FirstCache firstCache = cacheable.firstCache();
        SecondaryCache secondaryCache = cacheable.secondaryCache();
        FirstCacheSetting firstCacheSetting = new FirstCacheSetting(firstCache.initialCapacity(), firstCache.maximumSize(), (long)firstCache.expireTime(), firstCache.timeUnit(), firstCache.expireMode());
        SecondaryCacheSetting secondaryCacheSetting = new SecondaryCacheSetting(secondaryCache.expireTime(), secondaryCache.preloadTime(), secondaryCache.timeUnit(), secondaryCache.forceRefresh(), secondaryCache.isAllowNullValue(), secondaryCache.magnification());
        LayeringCacheSetting layeringCacheSetting = new LayeringCacheSetting(firstCacheSetting, secondaryCacheSetting, cacheable.depict());
        Cache cache = this.cacheManager.getCache(cacheName, layeringCacheSetting);
        return cache.get(key, () -> invoker.invoke());
    }

    private Object executeEvict(CacheOperationInvoker invoker, CacheEvict cacheEvict, Method method, Object[] args, Object target) {
        String[] cacheNames = cacheEvict.cacheNames();
        Assert.notEmpty((Object[])cacheEvict.cacheNames(), (String)CACHE_NAME_ERROR_MESSAGE);
        if (cacheEvict.allEntries()) {
            for (String cacheName : cacheNames) {
                Collection caches = this.cacheManager.getCache(cacheName);
                if (CollectionUtils.isEmpty((Collection)caches)) {
                    Cache cache = this.cacheManager.getCache(cacheName, new LayeringCacheSetting(new FirstCacheSetting(), new SecondaryCacheSetting(), "\u9ed8\u8ba4\u7f13\u5b58\u914d\u7f6e\uff08\u6e05\u9664\u65f6\u751f\u6210\uff09"));
                    cache.clear();
                    continue;
                }
                for (Cache cache : caches) {
                    cache.clear();
                }
            }
        } else {
            this.delete(cacheNames, cacheEvict.key(), method, args, target);
        }
        return invoker.invoke();
    }

    private void delete(String[] cacheNames, String keySpEL, Method method, Object[] args, Object target) {
        Object key = this.generateKey(keySpEL, method, args, target);
        Assert.notNull((Object)key, (String)String.format(CACHE_KEY_ERROR_MESSAGE, keySpEL));
        for (String cacheName : cacheNames) {
            Collection caches = this.cacheManager.getCache(cacheName);
            if (CollectionUtils.isEmpty((Collection)caches)) {
                Cache cache = this.cacheManager.getCache(cacheName, new LayeringCacheSetting(new FirstCacheSetting(), new SecondaryCacheSetting(), "\u9ed8\u8ba4\u7f13\u5b58\u914d\u7f6e\uff08\u5220\u9664\u65f6\u751f\u6210\uff09"));
                cache.evict(key);
                continue;
            }
            for (Cache cache : caches) {
                cache.evict(key);
            }
        }
    }

    private Object executePut(CacheOperationInvoker invoker, CachePut cachePut, Method method, Object[] args, Object target) {
        String[] cacheNames = cachePut.cacheNames();
        Assert.notEmpty((Object[])cachePut.cacheNames(), (String)CACHE_NAME_ERROR_MESSAGE);
        Object key = this.generateKey(cachePut.key(), method, args, target);
        Assert.notNull((Object)key, (String)String.format(CACHE_KEY_ERROR_MESSAGE, cachePut.key()));
        FirstCache firstCache = cachePut.firstCache();
        SecondaryCache secondaryCache = cachePut.secondaryCache();
        FirstCacheSetting firstCacheSetting = new FirstCacheSetting(firstCache.initialCapacity(), firstCache.maximumSize(), (long)firstCache.expireTime(), firstCache.timeUnit(), firstCache.expireMode());
        SecondaryCacheSetting secondaryCacheSetting = new SecondaryCacheSetting(secondaryCache.expireTime(), secondaryCache.preloadTime(), secondaryCache.timeUnit(), secondaryCache.forceRefresh(), secondaryCache.isAllowNullValue(), secondaryCache.magnification());
        LayeringCacheSetting layeringCacheSetting = new LayeringCacheSetting(firstCacheSetting, secondaryCacheSetting, cachePut.depict());
        Object result = invoker.invoke();
        for (String cacheName : cacheNames) {
            Cache cache = this.cacheManager.getCache(cacheName, layeringCacheSetting);
            cache.put(key, result);
        }
        return result;
    }

    private CacheOperationInvoker getCacheOperationInvoker(ProceedingJoinPoint joinPoint) {
        return () -> {
            try {
                return joinPoint.proceed();
            }
            catch (Throwable ex) {
                throw new CacheOperationInvoker.ThrowableWrapperException(ex);
            }
        };
    }

    private Object generateKey(String keySpEl, Method method, Object[] args, Object target) {
        Class<?> targetClass = this.getTargetClass(target);
        if (StringUtils.hasText((String)keySpEl)) {
            AnnotatedElementKey methodCacheKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
            EvaluationContext evaluationContext = this.evaluator.createEvaluationContext(method, args, target, targetClass, CacheOperationExpressionEvaluator.NO_RESULT);
            Object keyValue = this.evaluator.key(keySpEl, methodCacheKey, evaluationContext);
            return Objects.isNull(keyValue) ? "null" : keyValue;
        }
        return this.keyGenerator.generate(target, method, args);
    }

    private Class<?> getTargetClass(Object target) {
        Class<?> targetClass = AopProxyUtils.ultimateTargetClass((Object)target);
        if (targetClass == null) {
            targetClass = target.getClass();
        }
        return targetClass;
    }

    private Method getSpecificmethod(ProceedingJoinPoint pjp) {
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Class<?> targetClass = AopProxyUtils.ultimateTargetClass((Object)pjp.getTarget());
        if (targetClass == null && pjp.getTarget() != null) {
            targetClass = pjp.getTarget().getClass();
        }
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, (Class)targetClass);
        specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod);
        return specificMethod;
    }
}

