/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.down.plugins.ios;

import com.gluonhq.charm.down.Services;
import com.gluonhq.charm.down.plugins.Acceleration;
import com.gluonhq.charm.down.plugins.AccelerometerService;
import com.gluonhq.charm.down.plugins.LifecycleEvent;
import com.gluonhq.charm.down.plugins.LifecycleService;
import com.gluonhq.charm.down.plugins.ios.IOSPlatform;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;

public class IOSAccelerometerService
implements AccelerometerService {
    private static ReadOnlyObjectWrapper<Acceleration> acceleration;

    public IOSAccelerometerService() {
        acceleration = new ReadOnlyObjectWrapper();
        Services.get(LifecycleService.class).ifPresent(l -> {
            l.addListener(LifecycleEvent.PAUSE, IOSAccelerometerService::stopObserver);
            l.addListener(LifecycleEvent.RESUME, () -> IOSAccelerometerService.startObserver(false, 50));
        });
        IOSAccelerometerService.startObserver(false, 50);
    }

    public Acceleration getCurrentAcceleration() {
        return (Acceleration)acceleration.get();
    }

    public ReadOnlyObjectProperty<Acceleration> accelerationProperty() {
        return acceleration.getReadOnlyProperty();
    }

    private static native void initAccelerometer();

    private static native void startObserver(boolean var0, int var1);

    private static native void stopObserver();

    private void notifyAcceleration(double x, double y, double z, double t) {
        Acceleration a = new Acceleration(x, y, z, IOSAccelerometerService.toLocalDateTime(t));
        Platform.runLater(() -> acceleration.setValue((Object)a));
    }

    private static LocalDateTime toLocalDateTime(double t) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli((long)t), ZoneId.systemDefault());
    }

    static {
        IOSPlatform.init();
        System.loadLibrary("Accelerometer");
        IOSAccelerometerService.initAccelerometer();
    }
}

