/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.down.plugins.ios;

import com.gluonhq.charm.down.Services;
import com.gluonhq.charm.down.plugins.BatteryService;
import com.gluonhq.charm.down.plugins.LifecycleEvent;
import com.gluonhq.charm.down.plugins.LifecycleService;
import com.gluonhq.charm.down.plugins.ios.IOSPlatform;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyFloatProperty;
import javafx.beans.property.ReadOnlyFloatWrapper;

public class IOSBatteryService
implements BatteryService {
    private static final ReadOnlyBooleanWrapper PLUGGED_IN;
    private static final ReadOnlyFloatWrapper BATTERY_LEVEL;

    public IOSBatteryService() {
        Services.get(LifecycleService.class).ifPresent(l -> {
            l.addListener(LifecycleEvent.PAUSE, IOSBatteryService::stopObserver);
            l.addListener(LifecycleEvent.RESUME, IOSBatteryService::startObserver);
        });
        IOSBatteryService.startObserver();
    }

    public float getBatteryLevel() {
        return BATTERY_LEVEL.get();
    }

    public ReadOnlyFloatProperty batteryLevelProperty() {
        return BATTERY_LEVEL.getReadOnlyProperty();
    }

    public boolean isPluggedIn() {
        return PLUGGED_IN.get();
    }

    public ReadOnlyBooleanProperty pluggedInProperty() {
        return PLUGGED_IN.getReadOnlyProperty();
    }

    private static native void initBattery();

    private static native void startObserver();

    private static native void stopObserver();

    private void notifyBatteryState(String state) {
        boolean plugged;
        if (state == null) {
            return;
        }
        boolean bl = plugged = state.equals("Charging") || state.equals("Full");
        if (PLUGGED_IN != null && PLUGGED_IN.get() != plugged) {
            Platform.runLater(() -> PLUGGED_IN.set(plugged));
        }
    }

    private void notifyBatteryLevel(float level) {
        if (BATTERY_LEVEL != null && BATTERY_LEVEL.get() != level) {
            Platform.runLater(() -> BATTERY_LEVEL.set(level));
        }
    }

    static {
        IOSPlatform.init();
        System.loadLibrary("Battery");
        IOSBatteryService.initBattery();
        PLUGGED_IN = new ReadOnlyBooleanWrapper();
        BATTERY_LEVEL = new ReadOnlyFloatWrapper();
    }
}

