/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.down.plugins.ios;

import com.gluonhq.charm.down.Services;
import com.gluonhq.charm.down.plugins.LifecycleEvent;
import com.gluonhq.charm.down.plugins.LifecycleService;
import com.gluonhq.charm.down.plugins.Parameters;
import com.gluonhq.charm.down.plugins.Position;
import com.gluonhq.charm.down.plugins.PositionService;
import com.gluonhq.charm.down.plugins.ios.IOSPlatform;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;

public class IOSPositionService
implements PositionService {
    private static ReadOnlyObjectWrapper<Position> position;
    private static boolean running;
    private Parameters parameters;

    public IOSPositionService() {
        position = new ReadOnlyObjectWrapper();
        Services.get(LifecycleService.class).ifPresent(l -> {
            l.addListener(LifecycleEvent.PAUSE, () -> {
                if (!this.parameters.isBackgroundModeEnabled()) {
                    IOSPositionService.stopObserver();
                }
            });
            l.addListener(LifecycleEvent.RESUME, () -> {
                if (!this.parameters.isBackgroundModeEnabled()) {
                    IOSPositionService.startObserver(this.parameters.getAccuracy().name(), this.parameters.getTimeInterval(), this.parameters.getDistanceFilter(), this.parameters.isBackgroundModeEnabled());
                }
            });
        });
    }

    public void start() {
        this.start(DEFAULT_PARAMETERS);
    }

    public void start(Parameters parameters) {
        if (running) {
            this.stop();
        }
        this.parameters = parameters;
        IOSPositionService.startObserver(parameters.getAccuracy().name(), parameters.getTimeInterval(), parameters.getDistanceFilter(), parameters.isBackgroundModeEnabled());
        running = true;
    }

    public void stop() {
        IOSPositionService.stopObserver();
        running = false;
    }

    public ReadOnlyObjectProperty<Position> positionProperty() {
        return position.getReadOnlyProperty();
    }

    public Position getPosition() {
        return (Position)this.positionProperty().get();
    }

    private static native void initPosition();

    private static native void startObserver(String var0, long var1, float var3, boolean var4);

    private static native void stopObserver();

    private void setLocation(double lat, double lon) {
        Position p = new Position(lat, lon);
        Platform.runLater(() -> position.set((Object)p));
    }

    static {
        IOSPlatform.init();
        System.loadLibrary("Position");
        IOSPositionService.initPosition();
    }
}

