/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.impl.charm.down.plugins;

import com.gluonhq.charm.down.plugins.RuntimeArgsService;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultRuntimeArgsService
implements RuntimeArgsService {
    private static final Logger LOG = Logger.getLogger(DefaultRuntimeArgsService.class.getName());
    private static final Map<String, Consumer<String>> RUNTIME_MAP = new HashMap<String, Consumer<String>>();

    @Override
    public void fire(String key, String value) {
        if (RUNTIME_MAP.containsKey(key)) {
            if (RUNTIME_MAP.get(key) != null) {
                RUNTIME_MAP.get(key).accept(value);
            } else {
                LOG.log(Level.WARNING, String.format("Consumer for the key %s is null", key));
            }
        } else {
            LOG.log(Level.WARNING, String.format("The key %s was not found", key));
        }
    }

    @Override
    public void addListener(String key, Consumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException("Consumer can not be null");
        }
        if (RUNTIME_MAP.containsKey(key)) {
            throw new IllegalArgumentException("Key already registered");
        }
        if (RUNTIME_MAP.containsValue(consumer)) {
            throw new IllegalArgumentException("Consumer already registered");
        }
        RUNTIME_MAP.put(key, consumer);
        String value = System.getProperty(key, null);
        if (value != null && !value.isEmpty()) {
            try {
                System.clearProperty(key);
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, String.format("Error clearing system property for key %s: %s", key, e));
            }
            this.fire(key, value);
        }
    }

    @Override
    public void removeListener(String key) {
        RUNTIME_MAP.remove(key);
    }
}

