/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.down.plugins.android;

import android.content.SharedPreferences;
import com.gluonhq.charm.down.plugins.SettingsService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafxports.android.FXActivity;

public class AndroidSettingsService
implements SettingsService {
    private static final Logger LOG = Logger.getLogger(AndroidSettingsService.class.getName());
    private final SharedPreferences settings = FXActivity.getInstance().getSharedPreferences("settings", 0);

    public void store(String key, String value) {
        SharedPreferences.Editor editor = this.settings.edit();
        editor.putString(key, value);
        editor.commit();
        LOG.log(Level.INFO, String.format("Updated setting %s = \"%s\"", key, value));
    }

    public void remove(String key) {
        String value = this.retrieve(key);
        SharedPreferences.Editor editor = this.settings.edit();
        editor.remove(key);
        editor.commit();
        LOG.log(Level.INFO, String.format("Removed setting %s = \"%s\"", key, value));
    }

    public String retrieve(String key) {
        return this.settings.getString(key, null);
    }
}

