/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.down.plugins.android;

import android.os.Build;
import android.view.Window;
import com.gluonhq.charm.down.plugins.StatusBarService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.paint.Color;
import javafxports.android.FXActivity;

public class AndroidStatusBarService
implements StatusBarService {
    private static final Logger LOG = Logger.getLogger(AndroidStatusBarService.class.getName());

    public void setColor(Color color) {
        if (Build.VERSION.SDK_INT < 21) {
            Logger.getLogger(AndroidStatusBarService.class.getName()).log(Level.WARNING, "StatusBar service is not supported for the current Android version");
            return;
        }
        FXActivity activity = FXActivity.getInstance();
        if (activity == null) {
            LOG.log(Level.WARNING, "FXActivity not found. This service is not allowed when running in background mode or from wearable");
            return;
        }
        activity.runOnUiThread(() -> {
            Window window = activity.getWindow();
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(this.getIntColor(color));
        });
    }

    private int getIntColor(Color color) {
        int intColor = (int)Math.round(color.getBlue() * 255.0);
        intColor += (int)Math.round(color.getGreen() * 255.0) << 8;
        intColor += (int)Math.round(color.getRed() * 255.0) << 16;
        return intColor += (int)Math.round(color.getOpacity() * 255.0) << 24;
    }
}

