/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.down.plugins.desktop;

import com.gluonhq.charm.down.plugins.StorageService;
import java.io.File;
import java.util.Optional;

public class DesktopStorageService
implements StorageService {
    public Optional<File> getPrivateStorage() {
        try {
            String home = System.getProperty("user.home");
            File f = new File(home, ".gluon");
            if (!f.isDirectory()) {
                f.mkdirs();
            }
            return Optional.of(f);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Optional<File> getPublicStorage(String subdirectory) {
        try {
            String home = System.getProperty("user.home");
            File f = null == subdirectory ? new File(home) : new File(home, subdirectory);
            return Optional.of(f);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public boolean isExternalStorageWritable() {
        return true;
    }

    public boolean isExternalStorageReadable() {
        return true;
    }
}

