/*
 * Decompiled with CFR 0.152.
 */
package com.gluonhq.charm.down.plugins.android;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.SurfaceTexture;
import android.media.AudioManager;
import android.media.MediaMetadataRetriever;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.Patterns;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.MediaController;
import com.gluonhq.impl.charm.down.plugins.DefaultVideoService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.media.MediaPlayer;
import javafxports.android.FXActivity;

public class AndroidVideoService
extends DefaultVideoService
implements TextureView.SurfaceTextureListener,
MediaController.MediaPlayerControl {
    private static final Logger LOG = Logger.getLogger(AndroidVideoService.class.getName());
    private final FXActivity activity = FXActivity.getInstance();
    private MediaPlayer mediaPlayer;
    private MediaController mediaController;
    private String videoName;
    private final FrameLayout frameLayout;
    private final TextureView textureView;
    private boolean showing;
    private final BooleanProperty ready = new SimpleBooleanProperty();
    private boolean looping;
    private boolean controlsVisible;
    private final AudioManager audioManager;
    private final int maxVolume;
    private int preMuteVolume = 0;
    private int currentVolume = 0;
    private final ReadOnlyObjectWrapper<MediaPlayer.Status> status;
    private final BooleanProperty fullScreen;
    private final IntegerProperty currentIndex;
    private Pos alignment = Pos.CENTER;
    private double topPadding = 0.0;
    private double rightPadding = 0.0;
    private double bottomPadding = 0.0;
    private double leftPadding = 0.0;
    private double mediaHeight = 0.0;
    private double mediaWidth = 0.0;
    private boolean isVideo;
    private FileInputStream fis;
    private final ChangeListener<Boolean> readyListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> obs, Boolean ov, Boolean nv) {
            if (nv.booleanValue()) {
                AndroidVideoService.this.ready.removeListener((ChangeListener)this);
                if (AndroidVideoService.this.debug) {
                    LOG.log(Level.INFO, String.format("Video start playing [%d/%d]: %s", AndroidVideoService.this.currentIndex.get() + 1, AndroidVideoService.this.playlist.size(), AndroidVideoService.this.videoName));
                }
                AndroidVideoService.this.play();
            }
        }
    };
    private final ChangeListener<Number> indexListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            AndroidVideoService.this.pause();
            int index = newValue.intValue();
            if (0 <= index && index < AndroidVideoService.this.playlist.size()) {
                AndroidVideoService.this.nextMedia(index);
            } else if (AndroidVideoService.this.looping) {
                AndroidVideoService.this.currentIndex.set(0);
            } else {
                AndroidVideoService.this.nextMedia(-1);
            }
        }
    };

    public AndroidVideoService() {
        this.status = new ReadOnlyObjectWrapper((Object)MediaPlayer.Status.UNKNOWN);
        this.status.addListener((obs, ov, nv) -> {
            switch (nv) {
                case PLAYING: {
                    this.setScreenOn(true);
                    break;
                }
                default: {
                    this.setScreenOn(false);
                }
            }
        });
        this.currentIndex = new SimpleIntegerProperty();
        this.currentIndex.addListener(this.indexListener);
        this.fullScreen = new SimpleBooleanProperty(){

            protected void invalidated() {
                AndroidVideoService.this.updateSystemUI(this.get());
            }
        };
        this.playlist.addListener(o -> {
            if (this.playlist.isEmpty()) {
                this.hide();
            } else if (this.videoName != null) {
                if (!this.playlist.contains((Object)this.videoName)) {
                    if (this.currentIndex.get() == 0) {
                        this.currentIndex.set(-1);
                    }
                    this.currentIndex.set(0);
                } else {
                    int index = this.playlist.indexOf((Object)this.videoName);
                    if (index != this.currentIndex.get()) {
                        this.currentIndex.removeListener(this.indexListener);
                        this.currentIndex.set(index);
                        this.currentIndex.addListener(this.indexListener);
                    }
                }
            }
        });
        this.activity.setVolumeControlStream(3);
        this.audioManager = (AudioManager)this.activity.getSystemService("audio");
        this.maxVolume = this.audioManager.getStreamMaxVolume(3);
        this.frameLayout = new FrameLayout((Context)this.activity);
        this.textureView = new TextureView((Context)this.activity){
            private boolean scaling;
            private ScaleGestureDetector mScaleDetector;
            {
                AndroidVideoService.this.activity.runOnUiThread(() -> {
                    this.mScaleDetector = new ScaleGestureDetector((Context)AndroidVideoService.this.activity, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener(){

                        public void onScaleEnd(ScaleGestureDetector detector) {
                            super.onScaleEnd(detector);
                            if (AndroidVideoService.this.debug) {
                                LOG.log(Level.INFO, String.format("Pinch detected with scale %f", Float.valueOf(detector.getScaleFactor())));
                            }
                            if (AndroidVideoService.this.fullScreen.get() && (double)detector.getScaleFactor() < 1.0) {
                                AndroidVideoService.this.fullScreen.set(false);
                            } else if (!AndroidVideoService.this.fullScreen.get() && (double)detector.getScaleFactor() > 1.0) {
                                AndroidVideoService.this.fullScreen.set(true);
                            }
                            scaling = false;
                        }

                        public boolean onScaleBegin(ScaleGestureDetector detector) {
                            scaling = true;
                            return true;
                        }
                    });
                });
                this.setOnClickListener(v -> {
                    if (!this.scaling && AndroidVideoService.this.controlsVisible && AndroidVideoService.this.isVideo && AndroidVideoService.this.mediaController != null && !AndroidVideoService.this.mediaController.isShowing()) {
                        AndroidVideoService.this.mediaController.show();
                    }
                });
            }

            protected void onConfigurationChanged(Configuration newConfig) {
                super.onConfigurationChanged(newConfig);
                AndroidVideoService.this.resizeRelocateVideo();
            }

            public boolean dispatchKeyEvent(KeyEvent ke) {
                AndroidVideoService.this.dispatchVolume(ke);
                return true;
            }

            public boolean onTouchEvent(MotionEvent event) {
                this.requestFocus();
                this.mScaleDetector.onTouchEvent(event);
                return super.onTouchEvent(event);
            }
        };
        this.textureView.setFocusable(true);
        this.textureView.setFocusableInTouchMode(true);
        this.textureView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        this.frameLayout.addView((View)this.textureView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
    }

    public void show() {
        if (this.playlist.isEmpty()) {
            LOG.log(Level.WARNING, "The playlist is empty");
            return;
        }
        if (this.showing) {
            if (this.debug) {
                LOG.log(Level.INFO, "Video layer was already added");
            }
            return;
        }
        this.videoName = (String)this.playlist.get(this.currentIndex.get());
        this.ready.set(false);
        this.showing = true;
        if (this.prepareMedia()) {
            if (this.isVideo) {
                this.activity.runOnUiThread(() -> {
                    if (this.debug) {
                        LOG.log(Level.INFO, "Showing video layer");
                    }
                    FXActivity.getViewGroup().addView((View)this.frameLayout);
                    this.textureView.requestFocus();
                });
            } else {
                this.activity.runOnUiThread(() -> {
                    if (this.debug) {
                        LOG.log(Level.INFO, "Adding audio layer");
                    }
                    FXActivity.getViewGroup().addView((View)this.frameLayout, 0);
                    this.textureView.requestFocus();
                });
            }
        } else {
            if (this.debug) {
                LOG.log(Level.INFO, "Invalid media file found, trying the next one");
            }
            this.showing = false;
            this.ready.removeListener(this.readyListener);
            this.currentIndex.set(this.currentIndex.get() + 1);
        }
    }

    public void play() {
        if (this.playlist.isEmpty()) {
            LOG.log(Level.WARNING, "The playlist is empty");
            return;
        }
        if (this.status.get() == MediaPlayer.Status.STOPPED || this.status.get() == MediaPlayer.Status.DISPOSED) {
            this.updateStatus(MediaPlayer.Status.UNKNOWN);
            this.internalHide();
            this.currentIndex.set(0);
        }
        if (!this.ready.get()) {
            this.ready.addListener(this.readyListener);
            if (!this.showing) {
                this.show();
            }
        } else if (this.mediaPlayer != null) {
            if (this.debug) {
                LOG.log(Level.INFO, "Video play");
            }
            this.updateStatus(MediaPlayer.Status.PLAYING);
            this.mediaPlayer.start();
        }
    }

    public void pause() {
        if (this.mediaPlayer != null) {
            if (this.debug) {
                LOG.log(Level.INFO, "Video pause");
            }
            this.updateStatus(MediaPlayer.Status.PAUSED);
            this.mediaPlayer.pause();
        }
    }

    public void stop() {
        if (this.mediaPlayer != null) {
            if (this.debug) {
                LOG.log(Level.INFO, "Video stop");
            }
            this.mediaPlayer.stop();
            this.updateStatus(MediaPlayer.Status.STOPPED);
        }
    }

    public void hide() {
        this.internalHide();
        this.updateStatus(MediaPlayer.Status.DISPOSED);
    }

    public void setPosition(Pos alignment, double topPadding, double rightPadding, double bottomPadding, double leftPadding) {
        this.alignment = alignment;
        this.topPadding = topPadding;
        this.rightPadding = rightPadding;
        this.bottomPadding = bottomPadding;
        this.leftPadding = leftPadding;
    }

    public void setLooping(boolean looping) {
        this.looping = looping;
    }

    public void setControlsVisible(boolean controlsVisible) {
        this.controlsVisible = controlsVisible;
    }

    public void setFullScreen(boolean fullScreen) {
        this.fullScreen.set(fullScreen);
    }

    public BooleanProperty fullScreenProperty() {
        return this.fullScreen;
    }

    public ReadOnlyObjectProperty<MediaPlayer.Status> statusProperty() {
        return this.status.getReadOnlyProperty();
    }

    public void setCurrentIndex(int index) {
        if (index < 0 || index >= this.playlist.size()) {
            if (this.debug) {
                LOG.log(Level.INFO, "Wrong item value");
            }
            return;
        }
        this.currentIndex.set(index);
    }

    public IntegerProperty currentIndexProperty() {
        return this.currentIndex;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture st, int i, int i1) {
        if (this.debug) {
            LOG.log(Level.INFO, "Adding surface to Media player");
        }
        Surface surface = new Surface(st);
        this.mediaPlayer.setSurface(surface);
        this.setupMedia();
    }

    private void setupMedia() {
        this.resizeRelocateVideo();
        this.mediaPlayer.prepareAsync();
        this.mediaPlayer.setOnCompletionListener(mp -> this.currentIndex.set(this.currentIndex.get() + 1));
        this.mediaPlayer.setOnPreparedListener(mp -> {
            if (this.debug) {
                LOG.log(Level.INFO, "Media player prepared and ready");
            }
            if (this.controlsVisible && this.isVideo) {
                this.mediaController = new MediaController((Context)this.activity);
                this.mediaController.setMediaPlayer((MediaController.MediaPlayerControl)this);
                this.mediaController.setAnchorView((View)this.textureView);
                new Handler(this.activity.getMainLooper()).post(() -> {
                    if (this.mediaController != null) {
                        this.mediaController.setEnabled(true);
                        this.mediaController.show();
                    }
                });
            }
            this.updateStatus(MediaPlayer.Status.READY);
            this.ready.set(true);
        });
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture st, int i, int i1) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture st) {
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture st) {
    }

    public void start() {
        this.play();
    }

    public int getDuration() {
        return this.mediaPlayer.getDuration();
    }

    public int getCurrentPosition() {
        return this.mediaPlayer.getCurrentPosition();
    }

    public void seekTo(int i) {
        this.mediaPlayer.seekTo(i);
    }

    public boolean isPlaying() {
        return this.mediaPlayer.isPlaying();
    }

    public int getBufferPercentage() {
        return 0;
    }

    public boolean canPause() {
        return true;
    }

    public boolean canSeekBackward() {
        return true;
    }

    public boolean canSeekForward() {
        return true;
    }

    public int getAudioSessionId() {
        return 0;
    }

    private boolean prepareMedia() {
        try {
            if (this.debug) {
                LOG.log(Level.INFO, String.format("Creating new MediaPlayer for %s", this.videoName));
            }
            this.mediaPlayer = new MediaPlayer();
            MediaMetadataRetriever metaRetriever = new MediaMetadataRetriever();
            if (Patterns.WEB_URL.matcher(this.videoName).matches()) {
                metaRetriever.setDataSource(this.videoName, new HashMap());
                this.mediaPlayer.setDataSource((Context)this.activity, Uri.parse((String)this.videoName));
                if (this.debug) {
                    LOG.log(Level.INFO, String.format("Video file from URL: %s", Uri.parse((String)this.videoName).toString()));
                }
            } else {
                FileDescriptor fd = this.getFileDescriptor(this.videoName);
                if (fd != null) {
                    if (this.debug) {
                        LOG.log(Level.INFO, String.format("Got Video file from Resources: %s", fd.valid() ? "valid" : "invalid"));
                    }
                    metaRetriever.setDataSource(fd);
                    this.mediaPlayer.setDataSource(fd);
                    if (this.fis != null) {
                        this.fis.close();
                    }
                } else {
                    LOG.log(Level.WARNING, String.format("Invalid video file: %s", this.videoName));
                    this.updateStatus(MediaPlayer.Status.UNKNOWN);
                    this.mediaPlayer.release();
                    this.mediaPlayer = null;
                    return false;
                }
            }
            this.isVideo = metaRetriever.extractMetadata(17) != null;
            this.mediaHeight = this.parse(metaRetriever.extractMetadata(19));
            this.mediaWidth = this.parse(metaRetriever.extractMetadata(18));
            if (this.debug) {
                if (this.isVideo) {
                    LOG.log(Level.INFO, String.format("Video size: %f x %f", this.mediaWidth, this.mediaHeight));
                } else {
                    LOG.log(Level.INFO, "Audio file");
                }
            }
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.SEVERE, "Error loading content", e);
            this.updateStatus(MediaPlayer.Status.UNKNOWN);
            this.mediaPlayer.release();
            this.mediaPlayer = null;
            return false;
        }
        catch (SecurityException e) {
            LOG.log(Level.SEVERE, "Error loading content", e);
            this.updateStatus(MediaPlayer.Status.UNKNOWN);
            this.mediaPlayer.release();
            this.mediaPlayer = null;
            return false;
        }
        catch (IllegalStateException e) {
            LOG.log(Level.SEVERE, "Error loading content", e);
            this.updateStatus(MediaPlayer.Status.UNKNOWN);
            this.mediaPlayer.release();
            this.mediaPlayer = null;
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error loading content", e);
            this.updateStatus(MediaPlayer.Status.UNKNOWN);
            this.mediaPlayer.release();
            this.mediaPlayer = null;
            return false;
        }
        return true;
    }

    private void nextMedia(int index) {
        if (this.debug) {
            LOG.log(Level.INFO, "Hiding current video file");
        }
        this.internalHide();
        if (0 <= index && index < this.playlist.size()) {
            if (this.debug) {
                LOG.log(Level.INFO, String.format("Showing video file [%d/%d]", this.currentIndex.get() + 1, this.playlist.size()));
            }
            this.play();
        } else {
            if (this.debug) {
                LOG.log(Level.INFO, "Disposing media player");
            }
            if (this.fullScreen.get()) {
                this.fullScreen.set(false);
            }
            this.updateStatus(MediaPlayer.Status.DISPOSED);
        }
    }

    private void internalHide() {
        if (this.mediaPlayer != null) {
            if (this.debug) {
                LOG.log(Level.INFO, "Media Player release");
            }
            if (this.mediaController != null) {
                this.mediaController.hide();
                this.mediaController = null;
            }
            this.mediaPlayer.stop();
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
        this.showing = false;
        if (this.frameLayout != null) {
            this.activity.runOnUiThread(() -> FXActivity.getViewGroup().removeView((View)this.frameLayout));
        }
        this.ready.set(false);
    }

    private void resizeRelocateVideo() {
        int h;
        int w;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)this.activity.getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        float scaleFactor = (float)(!this.fullScreen.get() ? 1 : 0) * displayMetrics.scaledDensity;
        double maxW = (double)displayMetrics.widthPixels - (this.leftPadding + this.rightPadding) * (double)scaleFactor;
        double maxH = (double)displayMetrics.heightPixels - (this.topPadding + this.bottomPadding) * (double)scaleFactor;
        double screenFactor = maxW / maxH;
        if (this.isVideo) {
            double mediaFactor = this.mediaWidth / this.mediaHeight;
            if (mediaFactor > screenFactor) {
                w = (int)maxW;
                h = (int)(maxW / mediaFactor);
            } else {
                w = (int)(maxH * mediaFactor);
                h = (int)maxH;
            }
        } else {
            w = (int)maxW;
            h = (int)Math.min(maxH, 300.0);
        }
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(w, h, 17);
        if (!this.fullScreen.get()) {
            switch (this.alignment) {
                case TOP_LEFT: {
                    lp.gravity = 51;
                    break;
                }
                case TOP_CENTER: {
                    lp.gravity = 49;
                    break;
                }
                case TOP_RIGHT: {
                    lp.gravity = 53;
                    break;
                }
                case CENTER_LEFT: {
                    lp.gravity = 20;
                    break;
                }
                case CENTER: {
                    lp.gravity = 17;
                    break;
                }
                case CENTER_RIGHT: {
                    lp.gravity = 22;
                    break;
                }
                case BOTTOM_LEFT: {
                    lp.gravity = 83;
                    break;
                }
                case BOTTOM_CENTER: {
                    lp.gravity = 81;
                    break;
                }
                case BOTTOM_RIGHT: {
                    lp.gravity = 85;
                }
            }
        }
        lp.setMargins((int)(this.leftPadding * (double)scaleFactor), (int)(this.topPadding * (double)scaleFactor), (int)(this.rightPadding * (double)scaleFactor), (int)(this.bottomPadding * (double)scaleFactor));
        this.textureView.setLayoutParams((ViewGroup.LayoutParams)lp);
        if (this.debug) {
            LOG.log(Level.INFO, String.format("Media margins: %d %d %d %d", lp.topMargin, lp.rightMargin, lp.bottomMargin, lp.leftMargin));
        }
        this.textureView.setBackgroundColor(-65536);
        this.frameLayout.setBackgroundColor(this.fullScreen.get() ? -16777216 : 0);
        if (this.fullScreen.get() && !this.isVideo) {
            if (this.debug) {
                LOG.log(Level.INFO, "Audio file doesn't allow full screen mode");
            }
            Platform.runLater(() -> this.setFullScreen(false));
        }
    }

    private void updateSystemUI(boolean fullScreen) {
        if (this.mediaPlayer == null) {
            if (this.debug) {
                LOG.log(Level.INFO, "No media player found");
            }
            Platform.runLater(() -> this.setFullScreen(false));
            return;
        }
        if (fullScreen && !this.isVideo) {
            if (this.debug) {
                LOG.log(Level.INFO, "Audio file doesn't allow full screen mode");
            }
            Platform.runLater(() -> this.setFullScreen(false));
            return;
        }
        this.activity.runOnUiThread(() -> {
            if (fullScreen) {
                if (this.debug) {
                    LOG.log(Level.INFO, "Entering full screen mode");
                }
                this.activity.getWindow().getDecorView().setSystemUiVisibility(5894);
            } else {
                if (this.debug) {
                    LOG.log(Level.INFO, "Exiting full screen mode");
                }
                this.activity.getWindow().getDecorView().setSystemUiVisibility(256);
            }
            this.resizeRelocateVideo();
        });
    }

    private void setScreenOn(boolean on) {
        this.activity.runOnUiThread(() -> {
            Window window = this.activity.getWindow();
            if (on) {
                window.addFlags(128);
            } else {
                window.clearFlags(128);
            }
        });
    }

    private double parse(String s) {
        if (s == null || s.isEmpty()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    private void updateStatus(MediaPlayer.Status status) {
        if (this.status.get() != status) {
            Platform.runLater(() -> this.status.set((Object)status));
        }
    }

    private void dispatchVolume(KeyEvent ke) {
        if (ke.getAction() == 0) {
            this.currentVolume = this.audioManager.getStreamVolume(3);
            switch (ke.getKeyCode()) {
                case 24: {
                    this.audioManager.adjustStreamVolume(3, this.currentVolume + 1 <= this.maxVolume ? 1 : 0, 1);
                    break;
                }
                case 25: {
                    this.audioManager.adjustStreamVolume(3, this.currentVolume - 1 >= 0 ? -1 : 0, 1);
                    break;
                }
                case 164: {
                    if (this.currentVolume > 0) {
                        this.preMuteVolume = this.currentVolume;
                        this.audioManager.adjustStreamVolume(3, 0, 9);
                        break;
                    }
                    this.preMuteVolume = 0;
                    this.audioManager.adjustStreamVolume(3, this.preMuteVolume, 1);
                    break;
                }
            }
        }
    }

    private FileDescriptor getFileDescriptor(String filePath) {
        if (this.debug) {
            LOG.log(Level.INFO, String.format("Finding file descriptor for video file: %s", filePath));
        }
        try {
            if (this.playlistMap.get(filePath) == null) {
                if (this.debug) {
                    LOG.log(Level.INFO, String.format("Video file: %s not processed yet", filePath));
                }
                return null;
            }
            if (this.debug) {
                LOG.log(Level.INFO, String.format("Got file for video file: %s -> %s", filePath, (Boolean)this.playlistMap.get(filePath) != false ? "yes" : "no"));
            }
            if (!((Boolean)this.playlistMap.get(filePath)).booleanValue()) {
                if (this.debug) {
                    LOG.log(Level.INFO, String.format("Video file: %s not found", filePath));
                }
                return null;
            }
            File videoFile = this.getFileFromAssets(filePath);
            if (!videoFile.exists()) {
                return null;
            }
            this.fis = new FileInputStream(videoFile);
            return this.fis.getFD();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Error getting file descriptor", ex);
            return null;
        }
    }
}

