/*
 * Decompiled with CFR 0.152.
 */
package com.gs.obevo.db.impl.platforms.mssql;

import com.gs.obevo.db.api.platform.DbDeployerAppContext;
import com.gs.obevo.db.api.platform.DbPlatform;
import com.gs.obevo.db.impl.core.jdbc.JdbcHelper;
import com.gs.obevo.db.impl.platforms.mssql.MsSqlParamReader;
import java.sql.Connection;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.list.MutableList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MsSqlDeployerMainIT {
    private final IntToObjectFunction<DbDeployerAppContext> getAppContext;
    private final DataSource ds;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return MsSqlParamReader.getParamReader().getAppContextAndJdbcDsParams();
    }

    public MsSqlDeployerMainIT(IntToObjectFunction<DbDeployerAppContext> getAppContext, DataSource ds) {
        this.getAppContext = getAppContext;
        this.ds = ds;
    }

    @Test
    public void testAseDeploy() throws Exception {
        DbDeployerAppContext step1Context = (DbDeployerAppContext)this.getAppContext.valueOf(1);
        step1Context.cleanEnvironment().setupEnvInfra().deploy();
        String physicalSchemaStr = ((DbPlatform)step1Context.getEnvironment().getPlatform()).getSchemaPrefix(step1Context.getEnvironment().getPhysicalSchema("oats"));
        this.validateStep1(step1Context.getDataSource(), physicalSchemaStr, new JdbcHelper());
        DbDeployerAppContext step2Context = (DbDeployerAppContext)this.getAppContext.valueOf(2);
        step2Context.setupEnvInfra().deploy();
        this.validateStep2(step2Context.getDataSource(), physicalSchemaStr, new JdbcHelper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateStep1(DataSource ds, String physicalSchemaStr, JdbcHelper jdbc) throws Exception {
        MutableList results;
        Connection conn = ds.getConnection();
        try {
            results = jdbc.queryForList(conn, "select * from " + physicalSchemaStr + "TestTable order by idField");
        }
        finally {
            DbUtils.closeQuietly((Connection)conn);
        }
        Assert.assertEquals((long)4L, (long)results.size());
        this.validateResultRow((Map)results.get(0), 1, "str1", 0);
        this.validateResultRow((Map)results.get(1), 2, "str2", 0);
        this.validateResultRow((Map)results.get(2), 3, "str3", 0);
        this.validateResultRow((Map)results.get(3), 4, "str4", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateStep2(DataSource ds, String physicalSchemaStr, JdbcHelper jdbc) throws Exception {
        MutableList results;
        Connection conn = ds.getConnection();
        try {
            results = jdbc.queryForList(conn, "select * from " + physicalSchemaStr + "TestTable order by idField");
        }
        finally {
            DbUtils.closeQuietly((Connection)conn);
        }
        Assert.assertEquals((long)5L, (long)results.size());
        this.validateResultRow((Map)results.get(0), 1, "str1", 0);
        this.validateResultRow((Map)results.get(1), 3, "str3Changed", 0);
        this.validateResultRow((Map)results.get(2), 4, "str4", 0);
        this.validateResultRow((Map)results.get(3), 5, "str5", 0);
        this.validateResultRow((Map)results.get(4), 6, "str6", 0);
    }

    private void validateResultRow(Map<String, Object> map, Integer idField, String stringField, Integer booleanCol) {
        Assert.assertEquals((Object)idField, (Object)map.get("idField"));
        Assert.assertEquals((Object)stringField, (Object)map.get("stringField"));
        Assert.assertEquals((Object)booleanCol, (Object)map.get("myBooleanCol"));
    }
}

