/*
 * Decompiled with CFR 0.152.
 */
package com.gs.obevo.dbmetadata.impl.dialects;

import com.gs.obevo.api.appdata.PhysicalSchema;
import com.gs.obevo.db.impl.platforms.mssql.MsSqlDbPlatform;
import com.gs.obevo.db.impl.platforms.mssql.MsSqlParamReader;
import com.gs.obevo.dbmetadata.api.DbMetadataManager;
import com.gs.obevo.dbmetadata.impl.dialects.AbstractDbMetadataManagerIT;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MsSqlDbMetadataManagerIT
extends AbstractDbMetadataManagerIT {
    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return MsSqlParamReader.getParamReader().getJdbcDsAndSchemaParams();
    }

    public MsSqlDbMetadataManagerIT(DataSource dataSource, PhysicalSchema physicalSchema) {
        super(dataSource, physicalSchema);
    }

    protected DbMetadataManager createMetadataManager() {
        return new MsSqlDbPlatform().getDbMetadataManager();
    }

    protected void setCurrentSchema(QueryRunner jdbc) throws Exception {
        jdbc.update("USE " + this.getSchemaName());
    }

    protected String getDropSqlFile() {
        return "mssql-test-drops.sql";
    }

    protected String getAddSqlFile() {
        return "mssql-test.sql";
    }

    protected boolean isPmdKnownBroken() {
        return true;
    }

    protected String convertName(String name) {
        return name;
    }

    protected String get_VIEW1() {
        return "CREATE VIEW " + this.getSubschemaString() + "VIEW1 AS SELECT * FROM " + this.getSubschemaString() + "METADATA_TEST_TABLE -- my comment";
    }

    protected String get_INVALID_VIEW() {
        return "create view " + this.getSubschemaString() + "INVALID_VIEW AS SELECT * FROM " + this.getSubschemaString() + "INVALID_TABLE";
    }

    protected String get_SP1() {
        return "CREATE PROCEDURE " + this.getSubschemaString() + "SP1 AS -- ensure that SP comment remains DELETE FROM " + this.getSubschemaString() + "TABLE_A DELETE FROM " + this.getSubschemaString() + "TABLE_A";
    }

    protected String get_FUNC1() {
        return "CREATE FUNCTION " + this.getSubschemaString() + "FUNC1() RETURNS INT AS BEGIN -- ensure that func comment remains RETURN 10 END";
    }

    protected String get_FUNC_WITH_OVERLOAD_3() {
        return "-- NOTE - no function overloads supported in ASE CREATE FUNCTION " + this.getSubschemaString() + "FUNC_WITH_OVERLOAD (@var1 INT, @INVALSTR VARCHAR(32)) RETURNS INT AS BEGIN RETURN 10 END";
    }

    protected String get_SP_WITH_OVERLOAD_1() {
        return "CREATE PROCEDURE " + this.getSubschemaString() + "SP_WITH_OVERLOAD AS DELETE FROM " + this.getSubschemaString() + "TABLE_A";
    }

    protected String get_SP_WITH_OVERLOAD_2() {
        return "CREATE PROCEDURE " + this.getSubschemaString() + "SP_WITH_OVERLOAD;2 (@INVAL INT) AS DELETE FROM " + this.getSubschemaString() + "TABLE_A DELETE FROM " + this.getSubschemaString() + "TABLE_A";
    }

    protected String get_SP_WITH_OVERLOAD_3() {
        return "CREATE PROCEDURE " + this.getSubschemaString() + "SP_WITH_OVERLOAD AS DELETE FROM TABLE_A DELETE FROM " + this.getSubschemaString() + "TABLE_A DELETE FROM " + this.getSubschemaString() + "TABLE_A DELETE FROM " + this.getSubschemaString() + "TABLE_A";
    }

    protected boolean isFuncOverloadSupported() {
        return false;
    }

    protected boolean isSequenceSupported() {
        return false;
    }

    protected boolean isRuleBindingSupported() {
        return this.getPhysicalSchema().getSubschema() == null;
    }

    protected boolean isRuleSupported() {
        return true;
    }

    protected boolean isUserTypeSupported() {
        return true;
    }

    protected AbstractDbMetadataManagerIT.OverLoadSupport isSpOverloadSupported() {
        return AbstractDbMetadataManagerIT.OverLoadSupport.COMBINED_OBJECT;
    }
}

