/*
 * Decompiled with CFR 0.152.
 */
package com.gs.obevo.db.impl.platforms.sybasease;

import com.gs.obevo.api.appdata.PhysicalSchema;
import com.gs.obevo.api.platform.DeployerRuntimeException;
import com.gs.obevo.db.api.appdata.DbEnvironment;
import com.gs.obevo.db.api.appdata.Group;
import com.gs.obevo.db.api.appdata.User;
import com.gs.obevo.db.impl.core.envinfrasetup.EnvironmentInfraSetup;
import com.gs.obevo.db.impl.core.jdbc.DataAccessException;
import com.gs.obevo.db.impl.core.jdbc.JdbcHelper;
import com.gs.obevo.impl.DeployMetricsCollector;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.list.mutable.ListAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AseEnvironmentInfraSetup
implements EnvironmentInfraSetup {
    private static final Logger LOG = LoggerFactory.getLogger(AseEnvironmentInfraSetup.class);
    private final DbEnvironment env;
    private final DeployMetricsCollector deployMetricsCollector;
    private final JdbcHelper jdbc;
    private final DataSource ds;

    public AseEnvironmentInfraSetup(DbEnvironment env, DataSource ds, DeployMetricsCollector deployMetricsCollector) {
        this.env = env;
        this.jdbc = new JdbcHelper();
        this.ds = ds;
        this.deployMetricsCollector = deployMetricsCollector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupEnvInfra(boolean failOnSetupException) {
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            for (PhysicalSchema schema : this.env.getPhysicalSchemas()) {
                LOG.info("Verifying existence of Sybase groups and users in database {} prior to deployment", (Object)schema);
                this.setupGroups(conn, schema, failOnSetupException);
                this.setupUsers(conn, schema, failOnSetupException);
            }
        }
        catch (SQLException e) {
            if (failOnSetupException) {
                throw new DataAccessException((Throwable)e);
            }
            LOG.warn("Env Infra Setup connection failed", (Throwable)e);
            this.deployMetricsCollector.addMetric("warnings.aseEnvInfraSetupConnectionFailure", (Serializable)Boolean.valueOf(true));
            return;
        }
        finally {
            DbUtils.closeQuietly((Connection)conn);
        }
    }

    private void setupGroups(Connection conn, PhysicalSchema schema, boolean failOnSetupException) {
        MutableSet existingGroups;
        try {
            existingGroups = ListAdapter.adapt((List)((List)this.jdbc.query(conn, schema.getPhysicalName() + "..sp_helpgroup", (ResultSetHandler)new ColumnListHandler("Group_name")))).toSet();
        }
        catch (DataAccessException e) {
            if (failOnSetupException) {
                throw e;
            }
            LOG.warn("Group validation query failed; continuing w/ deployment per configuration", (Throwable)e);
            this.deployMetricsCollector.addMetric("warnings.aseGroupValidationQueryFailure", (Serializable)Boolean.valueOf(true));
            return;
        }
        ImmutableList missingGroups = this.env.getGroups().select((Predicate)Predicates.attributeNotIn((Function)Group.TO_NAME, (Iterable)existingGroups));
        MutableList failedGroups = Lists.mutable.empty();
        for (Group group : missingGroups) {
            LOG.info("Group " + group.getName() + " doesn't exist in database " + schema.getPhysicalName() + "; creating it now");
            try {
                this.jdbc.update(conn, schema.getPhysicalName() + "..sp_addgroup " + group.getName());
            }
            catch (DataAccessException sqlExc) {
                if (failOnSetupException) {
                    throw new DeployerRuntimeException("Failed to create group " + group.getName() + " in database " + schema.getPhysicalName() + " during setup; exiting the deploy", (Throwable)sqlExc);
                }
                LOG.warn("Group creation failed for group {} in database {}; continuing w/ deployment per configuration", new Object[]{group, schema, sqlExc});
                failedGroups.add((Object)group.getName());
            }
        }
        if (failedGroups.notEmpty()) {
            this.deployMetricsCollector.addMetric("warnings.aseGroupCreationFailure", (Serializable)((Object)("Failed creating groups " + failedGroups + " in database " + schema)));
        }
    }

    private void setupUsers(Connection conn, PhysicalSchema schema, boolean failOnSetupException) {
        MutableSet existingUsers;
        try {
            existingUsers = ListAdapter.adapt((List)((List)this.jdbc.query(conn, schema.getPhysicalName() + "..sp_helpuser", (ResultSetHandler)new ColumnListHandler("Users_name")))).toSet();
        }
        catch (DataAccessException e) {
            if (failOnSetupException) {
                throw e;
            }
            LOG.warn("User validation query failed; continuing w/ deployment per configuration", (Throwable)e);
            this.deployMetricsCollector.addMetric("warnings.aseUserValidationQueryFailure", (Serializable)Boolean.valueOf(true));
            return;
        }
        ImmutableList missingUsers = this.env.getUsers().select((Predicate)Predicates.attributeNotIn((Function)User.TO_NAME, (Iterable)existingUsers));
        if (missingUsers.notEmpty()) {
            String errorMessage = "Specified users " + missingUsers.collect(User.TO_NAME).makeString("[", ",", "]") + " do not exist in database " + schema.getPhysicalName() + "; please create the users or remove from your configuration (or rely on groups instead for permissions)";
            if (failOnSetupException) {
                throw new IllegalArgumentException(errorMessage);
            }
            LOG.warn(errorMessage);
            LOG.warn("Will proceed with deployment as you have configured this to just be a warning");
            this.deployMetricsCollector.addMetric("warnings.usersInConfigButNotInDb", (Serializable)((Object)errorMessage));
        }
    }
}

