/*
 * Decompiled with CFR 0.152.
 */
package com.gs.obevo.db.impl.platforms.sybasease;

import com.gs.obevo.api.appdata.Change;
import com.gs.obevo.db.impl.platforms.sqltranslator.ColumnSqlTranslator;
import com.gs.obevo.db.impl.platforms.sqltranslator.PostColumnSqlTranslator;
import com.gs.obevo.db.impl.platforms.sqltranslator.PostParsedSqlTranslator;
import com.gs.obevo.db.sqlparser.syntaxparser.CreateTable;
import com.gs.obevo.db.sqlparser.syntaxparser.CreateTableColumn;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AseToHsqlSqlTranslator
implements ColumnSqlTranslator,
PostColumnSqlTranslator,
PostParsedSqlTranslator {
    private final Pattern varbinaryDefaultPattern = Pattern.compile("(?i)varbinary\\s*([^\\(])");

    public String handleAnySqlPostTranslation(String string, Change change) {
        Matcher varbinaryDefaultMatcher;
        if (change != null && change.getMetadataSection() != null && change.getMetadataSection().isTogglePresent("DISABLE_QUOTED_IDENTIFIERS") && !change.getChangeType().getName().equals("VIEW")) {
            string = string.replace('\"', '\'');
        }
        if ((varbinaryDefaultMatcher = this.varbinaryDefaultPattern.matcher(string)).find()) {
            string = varbinaryDefaultMatcher.replaceFirst("varbinary(1)" + varbinaryDefaultMatcher.group(1));
        }
        return string;
    }

    public String handlePostColumnText(String postColumnText, CreateTableColumn column, CreateTable table) {
        postColumnText = postColumnText.replaceAll("(?i)\\bidentity\\s*(\\(.*\\))?", "GENERATED BY DEFAULT AS IDENTITY ");
        return postColumnText;
    }

    public CreateTableColumn handleColumn(CreateTableColumn column, CreateTable table) {
        String colTypeName = column.getType().getTypeName();
        if (colTypeName.equalsIgnoreCase("univarchar")) {
            colTypeName = "varchar";
        }
        return column.newWithType(column.getType().newWithTypeName(colTypeName));
    }
}

