/*
 * Decompiled with CFR 0.152.
 */
package com.gs.obevo.dbmetadata.impl.dialects;

import com.gs.obevo.db.impl.platforms.sybasease.AseDbPlatform;
import com.gs.obevo.db.impl.platforms.sybasease.AseParamReader;
import com.gs.obevo.dbmetadata.api.DbMetadataManager;
import com.gs.obevo.dbmetadata.impl.dialects.AbstractDbMetadataManagerIT;
import java.util.Collection;
import javax.sql.DataSource;
import org.apache.commons.dbutils.QueryRunner;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SybaseAseDbMetadataManagerIT
extends AbstractDbMetadataManagerIT {
    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return AseParamReader.getParamReader().getJdbcDsAndSchemaParams();
    }

    public SybaseAseDbMetadataManagerIT(DataSource dataSource, String schemaName) {
        super(dataSource, schemaName);
    }

    protected DbMetadataManager createMetadataManager() {
        return new AseDbPlatform().getDbMetadataManager();
    }

    protected void setCurrentSchema(QueryRunner jdbc) throws Exception {
        jdbc.update("USE " + this.getSchemaName());
    }

    protected String getDropSqlFile() {
        return "sybasease-test-drops.sql";
    }

    protected String getAddSqlFile() {
        return "sybasease-test.sql";
    }

    public static String createAseUrl(String host, int port) {
        return String.format("jdbc:sybase:Tds:%1$s:%2$s", host, port);
    }

    protected boolean isPmdKnownBroken() {
        return true;
    }

    protected String convertName(String name) {
        return name;
    }

    protected String get_VIEW1() {
        return "/* Adaptive Server has expanded all '*' elements in the following statement */ CREATE VIEW VIEW1 AS SELECT METADATA_TEST_TABLE.afield, METADATA_TEST_TABLE.bfield FROM METADATA_TEST_TABLE -- my comment";
    }

    protected String get_INVALID_VIEW() {
        return "/* Adaptive Server has expanded all '*' elements in the following statement */ create view INVALID_VIEW AS SELECT INVALID_TABLE.a FROM INVALID_TABLE";
    }

    protected String get_SP1() {
        return "CREATE PROCEDURE SP1 AS -- ensure that SP comment remains DELETE FROM TABLE_A DELETE FROM TABLE_A";
    }

    protected String get_FUNC1() {
        return "CREATE FUNCTION FUNC1 RETURNS INT AS -- ensure that func comment remains RETURN 10";
    }

    protected String get_FUNC_WITH_OVERLOAD_3() {
        return "CREATE FUNCTION FUNC_WITH_OVERLOAD (@var1 INT, @INVALSTR VARCHAR(32)) RETURNS INT AS RETURN 10";
    }

    protected String get_SP_WITH_OVERLOAD_1() {
        return "CREATE PROCEDURE SP_WITH_OVERLOAD AS DELETE FROM TABLE_A DELETE FROM TABLE_A";
    }

    protected String get_SP_WITH_OVERLOAD_2() {
        return "CREATE PROCEDURE SP_WITH_OVERLOAD;2 (@INVAL INT) AS DELETE FROM TABLE_A DELETE FROM TABLE_A";
    }

    protected String get_SP_WITH_OVERLOAD_3() {
        return "CREATE PROCEDURE SP_WITH_OVERLOAD;4 (@INVAL INT, @INVALSTR VARCHAR(32)) AS DELETE FROM TABLE_A DELETE FROM TABLE_A";
    }

    protected boolean isFuncOverloadSupported() {
        return false;
    }

    protected boolean isSequenceSupported() {
        return false;
    }

    protected boolean isRuleBindingSupported() {
        return true;
    }

    protected boolean isRuleSupported() {
        return true;
    }

    protected boolean isUserTypeSupported() {
        return true;
    }
}

