/*
 * Decompiled with CFR 0.152.
 */
package com.gs.obevo.db.apps.reveng;

import com.gs.obevo.db.apps.reveng.AquaRevengArgs;
import com.gs.obevo.db.apps.reveng.AquaRevengMain;
import com.gs.obevo.db.testutil.DirectoryAssert;
import com.gs.obevo.util.ArgsParser;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.junit.Test;

public class AseAquaRevengMainTest {
    @Test
    public void testAse() {
        AquaRevengMain reveng = new AquaRevengMain();
        File input = new File("./src/test/resources/reveng/ase/input");
        File outputDir = new File("./target/reveng-test/ase");
        FileUtils.deleteQuietly((File)outputDir);
        File expected = new File("./src/test/resources/reveng/ase/expected");
        String argsStr = String.format("-mode schema -inputDir %s -outputDir %s -generateBaseline -dbType %s -dbSchema %s", input, outputDir, "SYBASE_ASE", "dbdeploy01");
        AquaRevengArgs args = (AquaRevengArgs)new ArgsParser().parse(argsStr.split(" "), (Object)new AquaRevengArgs());
        reveng.execute(args);
        DirectoryAssert.assertDirectoriesEqual((File)expected, (File)new File(outputDir, "final"));
    }

    @Test
    public void testAseWithIndex() {
        AquaRevengMain reveng = new AquaRevengMain();
        File input = new File("./src/test/resources/reveng/ase/input-with-index");
        File outputDir = new File("./target/reveng-test/ase/output-with-index");
        FileUtils.deleteQuietly((File)outputDir);
        File expected = new File("./src/test/resources/reveng/ase/expected-withindexes");
        String argsStr = String.format("-mode schema -inputDir %s -outputDir %s -generateBaseline -dbType %s -dbSchema %s", input, outputDir, "SYBASE_ASE", "dbdeploy01");
        AquaRevengArgs args = (AquaRevengArgs)new ArgsParser().parse(argsStr.split(" "), (Object)new AquaRevengArgs());
        reveng.execute(args);
        DirectoryAssert.assertDirectoriesEqual((File)expected, (File)new File(outputDir, "final"));
    }
}

