/**
 * Copyright 2017 Goldman Sachs.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.gs.obevo.db.impl.platforms.sybasease;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

public class AseToHsqlSqlTranslatorTest {
    private final AseToHsqlSqlTranslator translator = new AseToHsqlSqlTranslator();

    @Test
    public void testVarbinaryChange() {
        assertEquals("varbinary(1)not null", this.translator.handleAnySqlPostTranslation("varbinary not null", null));
        assertEquals("varbinary(32) not null", this.translator.handleAnySqlPostTranslation("varbinary(32) not null", null));
    }

    @Test
    public void testPostColumnIdentity() throws Exception {
        assertEquals("GENERATED BY DEFAULT AS IDENTITY NOT NULL",
                this.translator.handlePostColumnText("IDENTITY NOT NULL", null, null));
        assertEquals("  GENERATED BY DEFAULT AS IDENTITY NOT NULL",
                this.translator.handlePostColumnText("  IDENTITY NOT NULL", null, null));
        assertEquals("sometext  GENERATED BY DEFAULT AS IDENTITY NOT NULL",
                this.translator.handlePostColumnText("sometext  IDENTITY NOT NULL", null, null));
    }
}