/*
 * Decompiled with CFR 0.152.
 */
package com.gs.obevo.db.impl.platforms.sybasease;

import com.gs.obevo.api.appdata.Change;
import com.gs.obevo.api.appdata.ObjectTypeAndNamePredicateBuilder;
import com.gs.obevo.api.appdata.PhysicalSchema;
import com.gs.obevo.api.platform.ChangeType;
import com.gs.obevo.api.platform.DeployerAppContext;
import com.gs.obevo.apps.reveng.ChangeEntry;
import com.gs.obevo.apps.reveng.Reveng;
import com.gs.obevo.db.api.appdata.DbEnvironment;
import com.gs.obevo.db.api.appdata.GrantTargetType;
import com.gs.obevo.db.api.platform.DbChangeTypeImpl;
import com.gs.obevo.db.api.platform.DbPlatform;
import com.gs.obevo.db.api.platform.DbTranslationDialect;
import com.gs.obevo.db.api.platform.SqlExecutor;
import com.gs.obevo.db.apps.reveng.AseDdlgenReveng;
import com.gs.obevo.db.impl.platforms.AbstractDbPlatform;
import com.gs.obevo.db.impl.platforms.sybasease.AseToH2TranslationDialect;
import com.gs.obevo.db.impl.platforms.sybasease.AseToHsqlTranslationDialect;
import com.gs.obevo.db.impl.platforms.sybasease.SybaseAseAppContext;
import java.sql.Connection;
import org.apache.commons.lang3.ObjectUtils;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.multimap.ImmutableMultimap;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Multimaps;

public class AseDbPlatform
extends AbstractDbPlatform {
    public AseDbPlatform() {
        super("SYBASE_ASE");
    }

    public Class<? extends DeployerAppContext> initializeAppContextBuilderClass() {
        return SybaseAseAppContext.class;
    }

    protected String initializeDefaultDriverClassName() {
        return "com.sybase.jdbc3.jdbc.SybDriver";
    }

    protected ImmutableList<ChangeType> initializeChangeTypes() {
        return super.initializeChangeTypes().newWithAll((Iterable)Lists.immutable.with((Object)DbChangeTypeImpl.newDbChangeType((String)"RULE", (boolean)true, (int)2, (String)"RULE").build(), (Object)DbChangeTypeImpl.newDbChangeType((String)"USERTYPE", (boolean)true, (int)3, (String)"DOMAIN").build(), (Object)DbChangeTypeImpl.newDbChangeType((String)"DEFAULT", (boolean)true, (int)5, (String)"DEFAULT").build()));
    }

    public boolean isDuplicateCheckRequiredForReverseEngineering() {
        return true;
    }

    public ObjectTypeAndNamePredicateBuilder getObjectExclusionPredicateBuilder() {
        return super.getObjectExclusionPredicateBuilder().add((ImmutableMultimap)Multimaps.immutable.set.with((Object)"TABLE", (Object)"rs_%", (Object)"SP", (Object)"rs_%"));
    }

    protected String getGrantTargetTypeStrDbSpecific(GrantTargetType grantTargetType) {
        return "";
    }

    public Function<String, String> convertDbObjectName() {
        return Functions.getPassThru();
    }

    public String getSchemaPrefix(PhysicalSchema schema) {
        return schema.getPhysicalName() + "." + (String)ObjectUtils.defaultIfNull((Object)schema.getSubschema(), (Object)"") + ".";
    }

    public String getSubschemaPrefix(PhysicalSchema schema) {
        return schema.getSubschema() != null ? schema.getSubschema() + "." : "";
    }

    @Deprecated
    public String getSchemaSeparator() {
        return "..";
    }

    public boolean isSubschemaSupported() {
        return true;
    }

    public void doTryBlockForArtifact(Connection conn, SqlExecutor sqlExecutor, Change artifact) {
        if (artifact.getMetadataSection() != null && artifact.getMetadataSection().isTogglePresent("DISABLE_QUOTED_IDENTIFIERS")) {
            sqlExecutor.getJdbcTemplate().update(conn, "SET quoted_identifier OFF");
        }
    }

    public void doFinallyBlockForArtifact(Connection conn, SqlExecutor sqlExecutor, Change artifact) {
        if (artifact.getMetadataSection() != null && artifact.getMetadataSection().isTogglePresent("DISABLE_QUOTED_IDENTIFIERS")) {
            sqlExecutor.getJdbcTemplate().update(conn, "SET quoted_identifier ON");
        }
    }

    public void postProcessChangeForRevEng(ChangeEntry change, String sql) {
        if (sql.contains("\"")) {
            change.addMetadataAnnotation("DISABLE_QUOTED_IDENTIFIERS");
        }
    }

    public DbTranslationDialect getDbTranslationDialect(DbPlatform targetDialect) {
        if (targetDialect.getClass().getName().equals("com.gs.obevo.db.impl.platforms.h2.H2DbPlatform")) {
            return new AseToH2TranslationDialect();
        }
        if (targetDialect.getClass().getName().equals("com.gs.obevo.db.impl.platforms.hsql.HsqlDbPlatform")) {
            return new AseToHsqlTranslationDialect();
        }
        return super.getDbTranslationDialect(targetDialect);
    }

    public String getTextType() {
        return "TEXT";
    }

    public String getBigIntType() {
        return "NUMERIC(19,0)";
    }

    public Reveng getDdlReveng() {
        return new AseDdlgenReveng();
    }

    public String getTableSuffixSql(DbEnvironment env) {
        return " LOCK DATAROWS";
    }
}

