/*
 * Decompiled with CFR 0.152.
 */
package com.gs.obevo.db.impl.platforms.sybasease;

import com.gs.obevo.api.appdata.PhysicalSchema;
import com.gs.obevo.api.platform.DeployerRuntimeException;
import com.gs.obevo.db.impl.core.jdbc.DefaultJdbcHandler;
import com.gs.obevo.db.impl.core.jdbc.JdbcHandler;
import com.gs.obevo.db.impl.core.jdbc.JdbcHelper;
import com.gs.obevo.db.impl.platforms.AbstractSqlExecutor;
import java.sql.Connection;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.joda.time.Seconds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AseSqlExecutor
extends AbstractSqlExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(AseSqlExecutor.class);
    private final AseJdbcHandler jdbcHandler = new AseJdbcHandler();

    public AseSqlExecutor(DataSource ds) {
        super(ds);
    }

    public void setDataSourceSchema(Connection conn, PhysicalSchema schema) {
        JdbcHelper jdbc = this.getJdbcTemplate();
        jdbc.update(conn, "use " + schema.getPhysicalName());
    }

    protected JdbcHandler getJdbcHandler() {
        return this.jdbcHandler;
    }

    protected int getPercentLogFullInDb(Connection conn, JdbcHelper jdbc) {
        return 0;
    }

    public class AseJdbcHandler
    extends DefaultJdbcHandler {
        private static final int stopLogSpaceThreshold = 85;
        private static final int resumeLogSpaceThreshold = 40;
        private static final int maxLogCounter = 10;
        private AtomicInteger curLogCounter = new AtomicInteger(0);

        public void preUpdate(Connection conn, JdbcHelper jdbc) {
            this.waitForLogSpace(conn, jdbc);
        }

        private void waitForLogSpace(Connection conn, JdbcHelper jdbc) {
            this.curLogCounter.incrementAndGet();
            if (this.curLogCounter.get() == 10) {
                boolean firstTime = true;
                while (true) {
                    int percentFull = AseSqlExecutor.this.getPercentLogFullInDb(conn, jdbc);
                    int thresholdToCheck = firstTime ? 85 : 40;
                    firstTime = false;
                    if (percentFull < thresholdToCheck) break;
                    try {
                        Seconds seconds = Seconds.seconds((int)3);
                        LOG.info(String.format("Pausing for %d seconds as the log level hit a high mark of %d; will resume when it gets back to %d", seconds.getSeconds(), percentFull, 40));
                        Thread.sleep(seconds.getSeconds() * 1000);
                    }
                    catch (InterruptedException e) {
                        throw new DeployerRuntimeException((Throwable)e);
                    }
                }
                this.curLogCounter.set(0);
            } else if (this.curLogCounter.get() > 10) {
                this.curLogCounter.set(0);
            }
        }
    }
}

