/*
 * Decompiled with CFR 0.152.
 */
package com.gs.obevo.db.impl.platforms.sybasease;

import com.gs.obevo.db.api.appdata.DbEnvironment;
import com.gs.obevo.db.api.platform.DbDeployerAppContext;
import com.gs.obevo.db.api.platform.DbPlatform;
import com.gs.obevo.db.impl.core.jdbc.JdbcDataSourceFactory;
import com.gs.obevo.db.impl.core.jdbc.JdbcHelper;
import com.gs.obevo.db.impl.platforms.h2.H2DbPlatform;
import com.gs.obevo.db.impl.platforms.hsql.HsqlDbPlatform;
import com.gs.obevo.db.impl.platforms.sybasease.SybaseAseDeployerMainIT;
import com.gs.obevo.db.unittest.UnitTestDbBuilder;
import com.gs.obevo.util.inputreader.Credential;
import javax.sql.DataSource;
import org.h2.Driver;
import org.hsqldb.jdbcDriver;
import org.junit.Test;

public class AseInMemConversionTest {
    @Test
    public void testH2Conversion() throws Exception {
        DbEnvironment dbEnv = (DbEnvironment)((DbDeployerAppContext)((DbDeployerAppContext)UnitTestDbBuilder.newBuilder().setSourcePath("platforms/sybasease/step1/system-config-inmem.xml").setReferenceEnvName("unittest-h2").setDbPlatform((DbPlatform)new H2DbPlatform()).setDbServer("mytest").buildContext().setupEnvInfra()).deploy()).setupAndCleanAndDeploy().getEnvironment();
        DataSource ds = JdbcDataSourceFactory.createFromJdbcUrl(Driver.class, (String)dbEnv.getJdbcUrl(), (Credential)new Credential(dbEnv.getDefaultUserId(), dbEnv.getDefaultPassword()));
        JdbcHelper jdbc = new JdbcHelper();
        String schemaPrefix = ((DbPlatform)dbEnv.getPlatform()).getSchemaPrefix(dbEnv.getPhysicalSchema("dbdeploy01"));
        SybaseAseDeployerMainIT.validateStep1(ds, jdbc, schemaPrefix);
        UnitTestDbBuilder.newBuilder().setSourcePath("platforms/sybasease/step2/system-config-inmem.xml").setReferenceEnvName("unittest-h2").setDbPlatform((DbPlatform)new H2DbPlatform()).setDbServer("mytest").buildContext().setupAndCleanAndDeploy();
        SybaseAseDeployerMainIT.validateStep2(ds, jdbc, schemaPrefix);
    }

    @Test
    public void testHsqlConversion() throws Exception {
        DbEnvironment dbEnv = (DbEnvironment)((DbDeployerAppContext)UnitTestDbBuilder.newBuilder().setSourcePath("platforms/sybasease/step1/system-config-inmem.xml").setReferenceEnvName("unittest-hsql").setDbPlatform((DbPlatform)new HsqlDbPlatform()).setDbServer("mytest").buildContext().setupEnvInfra()).cleanAndDeploy().setupAndCleanAndDeploy().getEnvironment();
        DataSource ds = JdbcDataSourceFactory.createFromJdbcUrl(jdbcDriver.class, (String)dbEnv.getJdbcUrl(), (Credential)new Credential(dbEnv.getDefaultUserId(), dbEnv.getDefaultPassword()));
        JdbcHelper jdbc = new JdbcHelper();
        String schemaPrefix = ((DbPlatform)dbEnv.getPlatform()).getSchemaPrefix(dbEnv.getPhysicalSchema("dbdeploy01"));
        SybaseAseDeployerMainIT.validateStep1(ds, jdbc, schemaPrefix);
        UnitTestDbBuilder.newBuilder().setSourcePath("platforms/sybasease/step2/system-config-inmem.xml").setReferenceEnvName("unittest-hsql").setDbPlatform((DbPlatform)new HsqlDbPlatform()).setDbServer("mytest").buildContext().setupAndCleanAndDeploy();
        SybaseAseDeployerMainIT.validateStep2(ds, jdbc, schemaPrefix);
    }
}

