/*
 * Decompiled with CFR 0.152.
 */
package com.gs.obevo.db.impl.platforms.sybasease;

import com.gs.obevo.api.appdata.DeployExecution;
import com.gs.obevo.api.appdata.DeployExecutionAttributeImpl;
import com.gs.obevo.api.appdata.PhysicalSchema;
import com.gs.obevo.api.platform.MainDeployerArgs;
import com.gs.obevo.db.api.appdata.DbEnvironment;
import com.gs.obevo.db.api.platform.DbDeployerAppContext;
import com.gs.obevo.db.api.platform.DbPlatform;
import com.gs.obevo.db.impl.core.jdbc.JdbcHelper;
import com.gs.obevo.db.impl.platforms.sybasease.AseParamReader;
import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.factory.Sets;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SybaseAseDeployerMainIT {
    private final IntToObjectFunction<DbDeployerAppContext> getAppContext;
    private final DataSource ds;

    @Parameterized.Parameters
    public static Iterable<Object[]> params() {
        return AseParamReader.getParamReader().getAppContextAndJdbcDsParams();
    }

    public SybaseAseDeployerMainIT(IntToObjectFunction<DbDeployerAppContext> getAppContext, DataSource ds) {
        this.getAppContext = getAppContext;
        this.ds = ds;
    }

    @Test
    public void testAseDeploy() throws Exception {
        MainDeployerArgs args1 = new MainDeployerArgs().deployExecutionAttributes(Sets.immutable.with((Object)new DeployExecutionAttributeImpl("attr1", "v1_val1"), (Object)new DeployExecutionAttributeImpl("attr2", "v1_val2"))).reason("try1");
        DbDeployerAppContext context1 = (DbDeployerAppContext)this.getAppContext.valueOf(1);
        ((DbDeployerAppContext)((DbDeployerAppContext)context1.cleanEnvironment()).setupEnvInfra()).deploy(args1);
        String schema = "dbdeploy01";
        PhysicalSchema physicalSchema = ((DbEnvironment)context1.getEnvironment()).getPhysicalSchema(schema);
        String schemaPrefix = ((DbPlatform)((DbEnvironment)context1.getEnvironment()).getPlatform()).getSchemaPrefix(physicalSchema);
        SybaseAseDeployerMainIT.validateStep1(this.ds, new JdbcHelper(), schemaPrefix);
        DeployExecution execution1 = context1.getDeployExecutionDao().getLatestDeployExecution(schema);
        this.verifyExecution1(execution1);
        MainDeployerArgs args2 = new MainDeployerArgs().deployExecutionAttributes(Sets.immutable.with((Object)new DeployExecutionAttributeImpl("attr1", "v2_val1"), (Object)new DeployExecutionAttributeImpl("attr2", "v2_val2"), (Object)new DeployExecutionAttributeImpl("attr3", "v2_val3"))).reason("try2");
        DbDeployerAppContext context2 = (DbDeployerAppContext)this.getAppContext.valueOf(2);
        ((DbDeployerAppContext)context2.setupEnvInfra()).deploy(args2);
        SybaseAseDeployerMainIT.validateStep2(this.ds, new JdbcHelper(), schemaPrefix);
        DeployExecution execution2 = context2.getDeployExecutionDao().getLatestDeployExecution(schema);
        this.verifyExecution2(execution2);
        MutableList executions = context2.getDeployExecutionDao().getDeployExecutions(schema).toSortedListBy((Function)new Function<DeployExecution, Long>(){

            public Long valueOf(DeployExecution deployExecution) {
                return deployExecution.getId();
            }
        });
        this.verifyExecution1((DeployExecution)executions.get(0));
        this.verifyExecution2((DeployExecution)executions.get(1));
    }

    private void verifyExecution1(DeployExecution execution1) {
        Assert.assertEquals((Object)"try1", (Object)execution1.getReason());
        Assert.assertEquals((Object)Sets.immutable.with((Object)new DeployExecutionAttributeImpl("attr1", "v1_val1"), (Object)new DeployExecutionAttributeImpl("attr2", "v1_val2")), (Object)execution1.getAttributes());
    }

    private void verifyExecution2(DeployExecution execution2) {
        Assert.assertEquals((Object)"try2", (Object)execution2.getReason());
        Assert.assertEquals((Object)Sets.immutable.with((Object)new DeployExecutionAttributeImpl("attr1", "v2_val1"), (Object)new DeployExecutionAttributeImpl("attr2", "v2_val2"), (Object)new DeployExecutionAttributeImpl("attr3", "v2_val3")), (Object)execution2.getAttributes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateStep1(DataSource ds, JdbcHelper jdbc, String schemaPrefix) throws Exception {
        MutableList results;
        Connection conn = ds.getConnection();
        try {
            results = jdbc.queryForList(conn, "select * from " + schemaPrefix + "TestTable order by idField");
        }
        finally {
            DbUtils.closeQuietly((Connection)conn);
        }
        Assert.assertEquals((long)4L, (long)results.size());
        SybaseAseDeployerMainIT.validateResultRow((Map)results.get(0), 1, "str1", 0);
        SybaseAseDeployerMainIT.validateResultRow((Map)results.get(1), 2, "str2", 0);
        SybaseAseDeployerMainIT.validateResultRow((Map)results.get(2), 3, "str3", 0);
        SybaseAseDeployerMainIT.validateResultRow((Map)results.get(3), 4, "str4", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateStep2(DataSource ds, JdbcHelper jdbc, String schemaPrefix) throws Exception {
        MutableList results;
        Connection conn = ds.getConnection();
        try {
            results = jdbc.queryForList(conn, "select * from " + schemaPrefix + "TestTable order by idField");
        }
        finally {
            DbUtils.closeQuietly((Connection)conn);
        }
        Assert.assertEquals((long)5L, (long)results.size());
        SybaseAseDeployerMainIT.validateResultRow((Map)results.get(0), 1, "str1", 0);
        SybaseAseDeployerMainIT.validateResultRow((Map)results.get(1), 3, "str3Changed", 0);
        SybaseAseDeployerMainIT.validateResultRow((Map)results.get(2), 4, "str4", 0);
        SybaseAseDeployerMainIT.validateResultRow((Map)results.get(3), 5, "str5", 0);
        SybaseAseDeployerMainIT.validateResultRow((Map)results.get(4), 6, "str6", 0);
    }

    private static void validateResultRow(Map<String, Object> map, Integer idField, String stringField, Integer booleanCol) {
        Assert.assertEquals((Object)idField, (Object)map.get("idField"));
        Assert.assertEquals((Object)stringField, (Object)map.get("stringField"));
        Assert.assertEquals((Object)booleanCol, (Object)map.get("myBooleanCol"));
    }
}

