/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.soap.jaxws;

import com.google.api.ads.common.lib.conf.AdsApiConfiguration;
import com.google.api.ads.common.lib.exception.ServiceException;
import com.google.api.ads.common.lib.utils.NodeExtractor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Node;

public class JaxWsSoapContextHandler
implements SOAPHandler<SOAPMessageContext> {
    private String lastSoapRequest;
    private String lastSoapResponse;
    private String lastRequestId;
    private String lastServiceCalled;
    private String lastOperationCalled;
    private Set<SOAPElement> soapHeaders = new HashSet<SOAPElement>();
    private final NodeExtractor nodeExtractor;
    private final ImmutableList<String> requestIdXPathComponents;

    public JaxWsSoapContextHandler(NodeExtractor nodeExtractor, AdsApiConfiguration adsApiConfiguration) {
        this.nodeExtractor = nodeExtractor;
        String requestIdXPath = adsApiConfiguration.getRequestIdXPath();
        this.requestIdXPathComponents = !Strings.isNullOrEmpty((String)requestIdXPath) ? ImmutableList.copyOf((Iterable)Splitter.on((char)'/').split((CharSequence)requestIdXPath)) : ImmutableList.of();
    }

    public boolean handleMessage(SOAPMessageContext context) {
        if (((Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
            SOAPMessage soapMessage = context.getMessage();
            try {
                SOAPHeader soapHeader = soapMessage.getSOAPHeader();
                if (soapHeader == null) {
                    soapHeader = soapMessage.getSOAPPart().getEnvelope().addHeader();
                }
                for (SOAPElement header : this.soapHeaders) {
                    soapHeader.addChildElement(header);
                }
            }
            catch (SOAPException e) {
                throw new ServiceException("Error setting SOAP headers on outbound message.", (Throwable)e);
            }
            this.captureServiceAndOperationNames(context);
        }
        this.captureSoapXml(context);
        return true;
    }

    @VisibleForTesting
    void captureServiceAndOperationNames(SOAPMessageContext context) {
        this.lastServiceCalled = ((QName)context.get((Object)"javax.xml.ws.wsdl.service")).getLocalPart();
        try {
            this.lastOperationCalled = context.getMessage().getSOAPBody().getFirstChild().getLocalName();
        }
        catch (SOAPException e) {
            this.lastOperationCalled = "";
        }
    }

    public String getLastOperationCalled() {
        return this.lastOperationCalled;
    }

    public String getLastServiceCalled() {
        return this.lastServiceCalled;
    }

    public boolean handleFault(SOAPMessageContext context) {
        this.captureSoapXml(context);
        return true;
    }

    private void captureSoapXml(SOAPMessageContext context) {
        SOAPMessage message = context.getMessage();
        String soapXml = "";
        try {
            Node requestIdNode;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            message.writeTo((OutputStream)outputStream);
            soapXml = ((Object)outputStream).toString();
            SOAPHeader soapHeader = message.getSOAPHeader();
            if (!((Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue() && soapHeader != null && !this.requestIdXPathComponents.isEmpty() && (requestIdNode = this.nodeExtractor.extractNode((Node)soapHeader, this.requestIdXPathComponents)) != null) {
                this.lastRequestId = requestIdNode.getFirstChild().getNodeValue();
            }
        }
        catch (IOException e) {
            soapXml = "Exception logging SOAP message: " + e;
        }
        catch (SOAPException e) {
            soapXml = "Exception logging SOAP message: " + (Object)((Object)e);
        }
        if (((Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound")).booleanValue()) {
            this.lastSoapRequest = soapXml;
        } else {
            this.lastSoapResponse = soapXml;
        }
    }

    public String getLastRequestXml() {
        return this.lastSoapRequest;
    }

    public String getLastResponseXml() {
        return this.lastSoapResponse;
    }

    public String getLastRequestId() {
        return this.lastRequestId;
    }

    public void addHeader(String namespace, String headerName, SOAPElement headerValue) {
        this.soapHeaders.add(headerValue);
    }

    public void clearHeaders() {
        this.soapHeaders.clear();
    }

    public Set<SOAPElement> getAddedHeaders() {
        return this.soapHeaders;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext messageContext) {
    }
}

