/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension;

import com.google.api.ads.adwords.axis.utility.extension.DelegateLocator;
import com.google.api.ads.adwords.axis.v201506.cm.Ad;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroup;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupAd;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupAdLabel;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupBidLandscape;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupCriterion;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupCriterionLabel;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupFeed;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupLabel;
import com.google.api.ads.adwords.axis.v201506.cm.AdParam;
import com.google.api.ads.adwords.axis.v201506.cm.CriterionBidLandscape;
import com.google.api.ads.adwords.axis.v201506.cm.CriterionUse;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.rmi.RemoteException;
import java.util.List;

public final class ExtendedAdGroup {
    private final DelegateLocator delegateLocator;
    private final AdGroup adGroup;

    public ExtendedAdGroup(AdGroup adGroup, DelegateLocator delegateLocator) {
        this.adGroup = adGroup;
        this.delegateLocator = delegateLocator;
    }

    public static List<ExtendedAdGroup> as(List<AdGroup> adGroups, final DelegateLocator delegateLocator) {
        if (adGroups == null || adGroups.isEmpty()) {
            return Lists.newArrayList();
        }
        return Lists.transform(adGroups, (Function)new Function<AdGroup, ExtendedAdGroup>(){

            public ExtendedAdGroup apply(AdGroup adGroup) {
                return new ExtendedAdGroup(adGroup, delegateLocator);
            }
        });
    }

    public DelegateLocator getDelegateLocator() {
        return this.delegateLocator;
    }

    public AdGroup getAdGroup() {
        return this.adGroup;
    }

    public ExtendedAdGroup update() throws RemoteException {
        return new ExtendedAdGroup(this.delegateLocator.getAdGroupDelegate().update(this.adGroup), this.delegateLocator);
    }

    public List<AdGroupCriterion> getAdGroupCriterions() throws RemoteException {
        return this.delegateLocator.getAdGroupCriterionDelegate().getByAdGroupId(this.adGroup.getId());
    }

    public List<AdGroupCriterion> getNegativeAdGroupCriterions() throws RemoteException {
        return this.delegateLocator.getAdGroupCriterionDelegate().getByAdGroupIdCriterionUse(this.adGroup.getId(), CriterionUse.NEGATIVE);
    }

    public List<AdGroupCriterion> getBiddableAdGroupCriterions() throws RemoteException {
        return this.delegateLocator.getAdGroupCriterionDelegate().getByAdGroupIdCriterionUse(this.adGroup.getId(), CriterionUse.BIDDABLE);
    }

    public List<AdGroupCriterion> insertAdGroupCriterions(List<AdGroupCriterion> adGroupCriterions) throws RemoteException {
        return this.delegateLocator.getAdGroupCriterionDelegate().insert(adGroupCriterions);
    }

    public AdGroupCriterion insertAdGroupCriterion(AdGroupCriterion adGroupCriterion) throws RemoteException {
        return this.delegateLocator.getAdGroupCriterionDelegate().insert(adGroupCriterion);
    }

    public List<AdGroupCriterion> updateBiddableAdGroupCriterions(List<AdGroupCriterion> adGroupCriterions) throws RemoteException {
        return this.delegateLocator.getAdGroupCriterionDelegate().update(adGroupCriterions);
    }

    public AdGroupCriterion updateBiddableAdGroupCriterion(AdGroupCriterion adGroupCriterion) throws RemoteException {
        return this.delegateLocator.getAdGroupCriterionDelegate().update(adGroupCriterion);
    }

    public List<AdGroupCriterion> removeAdGroupCriterions(List<AdGroupCriterion> adGroupCriterions) throws RemoteException {
        return this.delegateLocator.getAdGroupCriterionDelegate().remove(adGroupCriterions);
    }

    public AdGroupCriterion removeAdGroupCriterion(AdGroupCriterion adGroupCriterion) throws RemoteException {
        return this.delegateLocator.getAdGroupCriterionDelegate().remove(adGroupCriterion);
    }

    public List<AdGroupAd> getAdGroupAds() throws RemoteException {
        return this.delegateLocator.getAdGroupAdDelegate().getByAdGroupId(this.adGroup.getId());
    }

    public List<AdGroupAd> insertAdGroupAds(List<AdGroupAd> adGroupAds) throws RemoteException {
        return this.delegateLocator.getAdGroupAdDelegate().insert(adGroupAds);
    }

    public AdGroupAd insertAdGroupAd(AdGroupAd adGroupAd) throws RemoteException {
        return this.delegateLocator.getAdGroupAdDelegate().insert(adGroupAd);
    }

    public List<AdGroupAd> updateAdGroupAds(List<AdGroupAd> adGroupAds) throws RemoteException {
        return this.delegateLocator.getAdGroupAdDelegate().update(adGroupAds);
    }

    public AdGroupAd updateAdGroupAd(AdGroupAd adGroupAd) throws RemoteException {
        return this.delegateLocator.getAdGroupAdDelegate().update(adGroupAd);
    }

    public List<AdGroupAd> removeAdGroupAds(List<AdGroupAd> adGroupAds) throws RemoteException {
        return this.delegateLocator.getAdGroupAdDelegate().remove(adGroupAds);
    }

    public AdGroupAd removeAdGroupAd(AdGroupAd adGroupAd) throws RemoteException {
        return this.delegateLocator.getAdGroupAdDelegate().remove(adGroupAd);
    }

    public List<AdGroupAd> insertAds(List<Ad> ads) throws RemoteException {
        return this.delegateLocator.getAdGroupAdDelegate().insert(Lists.transform(ads, (Function)new Function<Ad, AdGroupAd>(){

            public AdGroupAd apply(Ad ad) {
                AdGroupAd adGroupAd = new AdGroupAd();
                adGroupAd.setAdGroupId(ExtendedAdGroup.this.adGroup.getId());
                adGroupAd.setAd(ad);
                return adGroupAd;
            }
        }));
    }

    public AdGroupAd insertAd(Ad ad) throws RemoteException {
        AdGroupAd adGroupAd = new AdGroupAd();
        adGroupAd.setAdGroupId(this.adGroup.getId());
        adGroupAd.setAd(ad);
        return this.delegateLocator.getAdGroupAdDelegate().insert(adGroupAd);
    }

    public List<AdParam> getAdParams() throws RemoteException {
        return this.delegateLocator.getAdParamDelegate().getByAdGroupId(this.adGroup.getId());
    }

    public List<AdParam> updateAdParams(List<AdParam> adParams) throws RemoteException {
        return this.delegateLocator.getAdParamDelegate().update(adParams);
    }

    public AdParam updateAdParam(AdParam adParam) throws RemoteException {
        return this.delegateLocator.getAdParamDelegate().update(adParam);
    }

    public List<AdParam> removeAdParams(List<AdParam> adParams) throws RemoteException {
        return this.delegateLocator.getAdParamDelegate().remove(adParams);
    }

    public AdParam removeAdParam(AdParam adParam) throws RemoteException {
        return this.delegateLocator.getAdParamDelegate().remove(adParam);
    }

    public List<AdGroupBidLandscape> getAdGroupBidLandscapes() throws RemoteException {
        return this.delegateLocator.getDataAdGroupBidLandscapeDelegate().getByAdGroupId(this.adGroup.getId());
    }

    public List<CriterionBidLandscape> getCriterionBidLandscape() throws RemoteException {
        return this.delegateLocator.getDataCriterionBidLandscapeDelegate().getByAdGroupId(this.adGroup.getId());
    }

    public List<AdGroupFeed> getAdGroupFeeds() throws RemoteException {
        return this.delegateLocator.getAdGroupFeedDelegate().getByAdGroupId(this.adGroup.getId());
    }

    public AdGroupLabel insertAdGroupLabel(Long labelId) throws RemoteException {
        AdGroupLabel adGroupLabel = new AdGroupLabel(this.getAdGroup().getId(), labelId);
        return this.delegateLocator.getAdGroupDelegate().insertAdGroupLabel(adGroupLabel);
    }

    public AdGroupLabel removeAdGroupLabel(Long labelId) throws RemoteException {
        AdGroupLabel adGroupLabel = new AdGroupLabel(this.getAdGroup().getId(), labelId);
        return this.delegateLocator.getAdGroupDelegate().removeAdGroupLabel(adGroupLabel);
    }

    public AdGroupAdLabel insertAdGroupAdLabel(Long labelId, long adId) throws RemoteException {
        AdGroupAdLabel adGroupAdLabel = new AdGroupAdLabel(this.getAdGroup().getId(), Long.valueOf(adId), labelId);
        return this.delegateLocator.getAdGroupAdDelegate().insertAdGroupAdLabel(adGroupAdLabel);
    }

    public AdGroupAdLabel removeAdGroupAdLabel(Long labelId, long adId) throws RemoteException {
        AdGroupAdLabel adGroupAdLabel = new AdGroupAdLabel(this.getAdGroup().getId(), Long.valueOf(adId), labelId);
        return this.delegateLocator.getAdGroupAdDelegate().removeAdGroupAdLabel(adGroupAdLabel);
    }

    public AdGroupCriterionLabel insertAdGroupCriterionLabel(Long labelId, long criterionId) throws RemoteException {
        AdGroupCriterionLabel adGroupCriterionLabel = new AdGroupCriterionLabel(this.getAdGroup().getId(), Long.valueOf(criterionId), labelId);
        return this.delegateLocator.getAdGroupCriterionDelegate().insertAdGroupCriterionLabel(adGroupCriterionLabel);
    }

    public AdGroupCriterionLabel removeAdGroupCriterionLabel(Long labelId, long criterionId) throws RemoteException {
        AdGroupCriterionLabel adGroupCriterionLabel = new AdGroupCriterionLabel(this.getAdGroup().getId(), Long.valueOf(criterionId), labelId);
        return this.delegateLocator.getAdGroupCriterionDelegate().removeAdGroupCriterionLabel(adGroupCriterionLabel);
    }
}

