/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension;

import com.google.api.ads.adwords.axis.utility.extension.DelegateLocator;
import com.google.api.ads.adwords.axis.utility.extension.ExtendedAdGroup;
import com.google.api.ads.adwords.axis.v201506.ch.CampaignChangeData;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroup;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupBidLandscape;
import com.google.api.ads.adwords.axis.v201506.cm.Campaign;
import com.google.api.ads.adwords.axis.v201506.cm.CampaignCriterion;
import com.google.api.ads.adwords.axis.v201506.cm.CampaignFeed;
import com.google.api.ads.adwords.axis.v201506.cm.CampaignLabel;
import com.google.api.ads.adwords.axis.v201506.cm.Criterion;
import com.google.api.ads.adwords.axis.v201506.cm.CriterionBidLandscape;
import com.google.api.ads.adwords.axis.v201506.cm.Experiment;
import com.google.api.ads.adwords.axis.v201506.cm.NegativeCampaignCriterion;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.List;

public final class ExtendedCampaign {
    private final DelegateLocator delegateLocator;
    private final Campaign campaign;

    public ExtendedCampaign(Campaign campaign, DelegateLocator delegateLocator) {
        this.campaign = campaign;
        this.delegateLocator = delegateLocator;
    }

    public static List<ExtendedCampaign> as(List<Campaign> campaigns, final DelegateLocator delegateLocator) {
        if (campaigns == null || campaigns.isEmpty()) {
            return Lists.newArrayList();
        }
        return Lists.transform(campaigns, (Function)new Function<Campaign, ExtendedCampaign>(){

            public ExtendedCampaign apply(Campaign campaign) {
                return new ExtendedCampaign(campaign, delegateLocator);
            }
        });
    }

    public DelegateLocator getDelegateLocator() {
        return this.delegateLocator;
    }

    public Campaign getCampaign() {
        return this.campaign;
    }

    public ExtendedCampaign update() throws RemoteException {
        return new ExtendedCampaign(this.delegateLocator.getCampaignDelegate().update(this.campaign), this.delegateLocator);
    }

    public List<ExtendedAdGroup> getExtendedAdGroups() throws RemoteException {
        return ExtendedAdGroup.as(this.delegateLocator.getAdGroupDelegate().getByCampaignId(this.campaign.getId()), this.delegateLocator);
    }

    public List<AdGroup> getAdGroups() throws RemoteException {
        return this.delegateLocator.getAdGroupDelegate().getByCampaignId(this.campaign.getId());
    }

    public List<ExtendedAdGroup> insertAdGroups(List<AdGroup> adGroups) throws RemoteException {
        for (AdGroup adGroup : adGroups) {
            if (adGroup.getCampaignId() != null) continue;
            adGroup.setCampaignId(this.campaign.getId());
        }
        return ExtendedAdGroup.as(this.delegateLocator.getAdGroupDelegate().insert(adGroups), this.delegateLocator);
    }

    public ExtendedAdGroup insertAdGroup(AdGroup adGroup) throws RemoteException {
        if (adGroup.getCampaignId() == null) {
            adGroup.setCampaignId(this.campaign.getId());
        }
        return new ExtendedAdGroup(this.delegateLocator.getAdGroupDelegate().insert(adGroup), this.delegateLocator);
    }

    public List<ExtendedAdGroup> updateAdGroups(List<AdGroup> adGroups) throws RemoteException {
        for (AdGroup adGroup : adGroups) {
            if (adGroup.getCampaignId() != null) continue;
            adGroup.setCampaignId(this.campaign.getId());
        }
        return ExtendedAdGroup.as(this.delegateLocator.getAdGroupDelegate().update(adGroups), this.delegateLocator);
    }

    public List<CampaignCriterion> getCampaignCriterions() throws RemoteException {
        return this.delegateLocator.getCampaignCriterionDelegate().getByCampaignId(this.campaign.getId());
    }

    public List<CampaignCriterion> insertCampaignCriterions(List<CampaignCriterion> campaignCriterions) throws RemoteException {
        return this.delegateLocator.getCampaignCriterionDelegate().insert(campaignCriterions);
    }

    public CampaignCriterion insertCampaignCriterion(CampaignCriterion campaignCriterion) throws RemoteException {
        return this.delegateLocator.getCampaignCriterionDelegate().insert(campaignCriterion);
    }

    public CampaignCriterion insertCampaignCriterion(Criterion criterion) throws RemoteException {
        CampaignCriterion campaignCriterion = new CampaignCriterion();
        campaignCriterion.setCampaignId(this.getCampaign().getId());
        campaignCriterion.setCriterion(criterion);
        return this.delegateLocator.getCampaignCriterionDelegate().insert(campaignCriterion);
    }

    public CampaignCriterion insertNegativeCampaignCriterion(Criterion criterion) throws RemoteException {
        NegativeCampaignCriterion negativeCampaignCriterion = new NegativeCampaignCriterion();
        negativeCampaignCriterion.setCampaignId(this.getCampaign().getId());
        negativeCampaignCriterion.setCriterion(criterion);
        return (CampaignCriterion)this.delegateLocator.getCampaignCriterionDelegate().insert(negativeCampaignCriterion);
    }

    public List<CampaignCriterion> updateCampaignCriterions(List<CampaignCriterion> campaignCriterions) throws RemoteException {
        return this.delegateLocator.getCampaignCriterionDelegate().update(campaignCriterions);
    }

    public CampaignCriterion updateCampaignCriterion(CampaignCriterion campaignCriterion) throws RemoteException {
        return this.delegateLocator.getCampaignCriterionDelegate().update(campaignCriterion);
    }

    public List<CampaignCriterion> removeCampaignCriterions(List<CampaignCriterion> campaignCriterions) throws RemoteException {
        return this.delegateLocator.getCampaignCriterionDelegate().remove(campaignCriterions);
    }

    public CampaignCriterion removeCampaignCriterion(CampaignCriterion campaignCriterion) throws RemoteException {
        return this.delegateLocator.getCampaignCriterionDelegate().remove(campaignCriterion);
    }

    public List<Experiment> getExperiments() throws RemoteException {
        return this.delegateLocator.getExperimentDelegate().getByCampaignId(this.campaign.getId());
    }

    public List<Experiment> insertExperiments(List<Experiment> experiments) throws RemoteException {
        return this.delegateLocator.getExperimentDelegate().insert(experiments);
    }

    public Experiment insertExperiment(Experiment experiment) throws RemoteException {
        return this.delegateLocator.getExperimentDelegate().insert(experiment);
    }

    public List<Experiment> updateExperiments(List<Experiment> experiments) throws RemoteException {
        return this.delegateLocator.getExperimentDelegate().update(experiments);
    }

    public Experiment updateExperiment(Experiment experiment) throws RemoteException {
        return this.delegateLocator.getExperimentDelegate().update(experiment);
    }

    public List<AdGroupBidLandscape> getAdGroupBidLandscapes() throws RemoteException {
        return this.delegateLocator.getDataAdGroupBidLandscapeDelegate().getByCampaignId(this.campaign.getId());
    }

    public List<CriterionBidLandscape> getCriterionBidLandscape() throws RemoteException {
        return this.delegateLocator.getDataCriterionBidLandscapeDelegate().getByCampaignId(this.campaign.getId());
    }

    public List<CampaignChangeData> getCampaignChangeData(Date dateStart, Date dateEnd) throws RemoteException {
        return this.delegateLocator.getCustomerSyncDelegate().getCampaignChangeData(this.campaign.getId(), dateStart, dateEnd);
    }

    public List<CampaignFeed> getCampaignFeeds() throws RemoteException {
        return this.delegateLocator.getCampaignFeedDelegate().getByCampaignId(this.campaign.getId());
    }

    public CampaignLabel insertCampaignLabel(Long labelId) throws RemoteException {
        CampaignLabel campaignLabel = new CampaignLabel(this.getCampaign().getId(), labelId);
        return this.delegateLocator.getCampaignDelegate().insertCampaignLabel(campaignLabel);
    }

    public CampaignLabel removeCampaignLabel(Long labelId) throws RemoteException {
        CampaignLabel campaignLabel = new CampaignLabel(this.getCampaign().getId(), labelId);
        return this.delegateLocator.getCampaignDelegate().removeCampaignLabel(campaignLabel);
    }
}

