/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension;

import com.google.api.ads.adwords.axis.utility.extension.DelegateLocator;
import com.google.api.ads.adwords.axis.utility.extension.ExtendedAdGroup;
import com.google.api.ads.adwords.axis.utility.extension.ExtendedCampaign;
import com.google.api.ads.adwords.axis.utility.extension.ExtendedMcc;
import com.google.api.ads.adwords.axis.utility.extension.exception.UtilityLibraryException;
import com.google.api.ads.adwords.axis.utility.extension.util.AdWordsSessionUtil;
import com.google.api.ads.adwords.axis.v201506.billing.BillingAccount;
import com.google.api.ads.adwords.axis.v201506.billing.BudgetOrder;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroup;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupAd;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupCriterion;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupFeed;
import com.google.api.ads.adwords.axis.v201506.cm.AdParam;
import com.google.api.ads.adwords.axis.v201506.cm.Budget;
import com.google.api.ads.adwords.axis.v201506.cm.Campaign;
import com.google.api.ads.adwords.axis.v201506.cm.CampaignCriterion;
import com.google.api.ads.adwords.axis.v201506.cm.CampaignFeed;
import com.google.api.ads.adwords.axis.v201506.cm.CampaignStatus;
import com.google.api.ads.adwords.axis.v201506.cm.Feed;
import com.google.api.ads.adwords.axis.v201506.cm.FeedItem;
import com.google.api.ads.adwords.axis.v201506.cm.FeedMapping;
import com.google.api.ads.adwords.axis.v201506.cm.Label;
import com.google.api.ads.adwords.axis.v201506.cm.LabelStatus;
import com.google.api.ads.adwords.axis.v201506.mcm.ManagedCustomer;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.OAuthException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.common.collect.Lists;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public final class ExtendedManagedCustomer {
    private final DelegateLocator delegateLocator;
    private final ManagedCustomer managedCustomer;

    public ExtendedManagedCustomer(ManagedCustomer managedCustomer, AdWordsSession adWordsSession) {
        this.managedCustomer = managedCustomer;
        this.delegateLocator = new DelegateLocator(adWordsSession, managedCustomer);
    }

    public ExtendedManagedCustomer(AdWordsSession adWordsSession) throws NumberFormatException, RemoteException {
        ManagedCustomer managedCustomer;
        if (adWordsSession.getClientCustomerId() == null) {
            throw new UtilityLibraryException("Please set api.adwords.clientCustomerId in ads.properties");
        }
        ExtendedMcc extendedMcc = new ExtendedMcc(adWordsSession);
        this.managedCustomer = managedCustomer = extendedMcc.getManagedCustomer(adWordsSession.getClientCustomerId());
        this.delegateLocator = new DelegateLocator(adWordsSession, managedCustomer);
    }

    public ExtendedManagedCustomer(ManagedCustomer managedCustomer, DelegateLocator delegateLocator) {
        this.managedCustomer = managedCustomer;
        this.delegateLocator = delegateLocator;
    }

    public static ExtendedManagedCustomer withOAuth2FromFile() throws OAuthException, ValidationException, ConfigurationLoadException, NumberFormatException, RemoteException {
        return new ExtendedManagedCustomer(AdWordsSessionUtil.fromFileWithOAuth2());
    }

    public static List<ExtendedManagedCustomer> as(List<ManagedCustomer> managedCustomers, AdWordsSession adWordsSession) {
        ArrayList listExtended = Lists.newArrayListWithCapacity((int)managedCustomers.size());
        for (ManagedCustomer managedCustomer : managedCustomers) {
            listExtended.add(new ExtendedManagedCustomer(managedCustomer, adWordsSession));
        }
        return listExtended;
    }

    public DelegateLocator getDelegateLocator() {
        return this.delegateLocator;
    }

    public ManagedCustomer getManagedCustomer() {
        return this.managedCustomer;
    }

    public List<Campaign> getCampaigns() throws RemoteException {
        return this.delegateLocator.getCampaignDelegate().get();
    }

    public Campaign getCampaign(Long campaignId) throws RemoteException {
        return this.delegateLocator.getCampaignDelegate().getByCampaignId(campaignId);
    }

    public List<Campaign> getCampaignsByStatus(CampaignStatus campaignStatus) throws RemoteException {
        return this.delegateLocator.getCampaignDelegate().getByStatus(campaignStatus);
    }

    public List<Campaign> getCampaignsByLabelIds(List<Long> labelIds) throws RemoteException {
        return this.delegateLocator.getCampaignDelegate().getByLabelIds(labelIds);
    }

    public List<ExtendedCampaign> getExtendedCampaigns() throws RemoteException {
        return ExtendedCampaign.as(this.delegateLocator.getCampaignDelegate().get(), this.delegateLocator);
    }

    public ExtendedCampaign getExtendedCampaign(Long campaignId) throws RemoteException {
        return new ExtendedCampaign(this.delegateLocator.getCampaignDelegate().getByCampaignId(campaignId), this.delegateLocator);
    }

    public List<ExtendedCampaign> getExtendedCampaignsByStatus(CampaignStatus campaignStatus) throws RemoteException {
        return ExtendedCampaign.as(this.delegateLocator.getCampaignDelegate().getByStatus(campaignStatus), this.delegateLocator);
    }

    public List<ExtendedCampaign> getExtendedCampaignsByLabelIds(List<Long> labelIds) throws RemoteException {
        return ExtendedCampaign.as(this.delegateLocator.getCampaignDelegate().getByLabelIds(labelIds), this.delegateLocator);
    }

    public List<ExtendedCampaign> insertCampaigns(List<Campaign> campaigns) throws RemoteException {
        return ExtendedCampaign.as(this.delegateLocator.getCampaignDelegate().insert(campaigns), this.delegateLocator);
    }

    public ExtendedCampaign insertCampaign(Campaign campaign) throws RemoteException {
        return new ExtendedCampaign(this.delegateLocator.getCampaignDelegate().insert(campaign), this.delegateLocator);
    }

    public List<ExtendedCampaign> updateCampaigns(List<Campaign> campaigns) throws RemoteException {
        return ExtendedCampaign.as(this.delegateLocator.getCampaignDelegate().update(campaigns), this.delegateLocator);
    }

    public ExtendedCampaign updateCampaign(Campaign campaign) throws RemoteException {
        return new ExtendedCampaign(this.delegateLocator.getCampaignDelegate().update(campaign), this.delegateLocator);
    }

    public List<ExtendedAdGroup> getExtendedAdGroups() throws RemoteException {
        return ExtendedAdGroup.as(this.delegateLocator.getAdGroupDelegate().get(), this.delegateLocator);
    }

    public List<AdGroup> getAdGroups() throws RemoteException {
        return this.delegateLocator.getAdGroupDelegate().get();
    }

    public List<CampaignCriterion> getCampaignCriterions() throws RemoteException {
        return this.delegateLocator.getCampaignCriterionDelegate().get();
    }

    public List<AdGroupCriterion> getAdGroupCriterions() throws RemoteException {
        return this.delegateLocator.getAdGroupCriterionDelegate().get();
    }

    public List<AdGroupAd> getAdGroupAds() throws RemoteException {
        return this.delegateLocator.getAdGroupAdDelegate().get();
    }

    public List<AdParam> getAdParams() throws RemoteException {
        return this.delegateLocator.getAdParamDelegate().get();
    }

    public List<BudgetOrder> getBudgetOrders() throws RemoteException {
        return this.delegateLocator.getBudgetOrderDelegate().get();
    }

    public BudgetOrder insertBudgetOrder(BudgetOrder budgetOrder) throws RemoteException {
        return this.delegateLocator.getBudgetOrderDelegate().insert(budgetOrder);
    }

    public BudgetOrder updateBudgetOrder(BudgetOrder budgetOrder) throws RemoteException {
        return this.delegateLocator.getBudgetOrderDelegate().update(budgetOrder);
    }

    public BudgetOrder removeBudgetOrder(BudgetOrder budgetOrder) throws RemoteException {
        return this.delegateLocator.getBudgetOrderDelegate().remove(budgetOrder);
    }

    public List<BillingAccount> getBillingAccounts() throws RemoteException {
        return this.delegateLocator.getBudgetOrderDelegate().getBillingAccounts();
    }

    public List<Budget> getBudgets() throws RemoteException {
        return this.delegateLocator.getBudgetDelegate().get();
    }

    public Budget insertBudget(Budget budget) throws RemoteException {
        return this.delegateLocator.getBudgetDelegate().insert(budget);
    }

    public List<Budget> insertBudgets(List<Budget> budgets) throws RemoteException {
        return this.delegateLocator.getBudgetDelegate().insert(budgets);
    }

    public Budget updateBudget(Budget budget) throws RemoteException {
        return this.delegateLocator.getBudgetDelegate().update(budget);
    }

    public List<Budget> updateBudgets(List<Budget> budgets) throws RemoteException {
        return this.delegateLocator.getBudgetDelegate().update(budgets);
    }

    public Budget removeBudget(Budget budget) throws RemoteException {
        return this.delegateLocator.getBudgetDelegate().remove(budget);
    }

    public List<Budget> removeBudgets(List<Budget> budgets) throws RemoteException {
        return this.delegateLocator.getBudgetDelegate().remove(budgets);
    }

    public List<Feed> getFeeds() throws RemoteException {
        return this.delegateLocator.getFeedDelegate().get();
    }

    public List<Feed> getFeeds(Long feedId) throws RemoteException {
        return this.delegateLocator.getFeedDelegate().getByFeedId(feedId);
    }

    public Feed insertFeed(Feed feed) throws RemoteException {
        return this.delegateLocator.getFeedDelegate().insert(feed);
    }

    public List<Feed> insertFeeds(List<Feed> feeds) throws RemoteException {
        return this.delegateLocator.getFeedDelegate().insert(feeds);
    }

    public Feed updateFeed(Feed feed) throws RemoteException {
        return this.delegateLocator.getFeedDelegate().update(feed);
    }

    public List<Feed> updateFeeds(List<Feed> feeds) throws RemoteException {
        return this.delegateLocator.getFeedDelegate().update(feeds);
    }

    public Feed removeFeed(Feed feed) throws RemoteException {
        return this.delegateLocator.getFeedDelegate().remove(feed);
    }

    public List<Feed> removeFeeds(List<Feed> feeds) throws RemoteException {
        return this.delegateLocator.getFeedDelegate().remove(feeds);
    }

    public List<FeedItem> getFeedItems() throws RemoteException {
        return this.delegateLocator.getFeedItemDelegate().get();
    }

    public List<FeedItem> getFeedItems(Long feedId) throws RemoteException {
        return this.delegateLocator.getFeedItemDelegate().getByFeedId(feedId);
    }

    public FeedItem insertFeedItem(FeedItem feedItem) throws RemoteException {
        return this.delegateLocator.getFeedItemDelegate().insert(feedItem);
    }

    public List<FeedItem> insertFeedItems(List<FeedItem> feedItems) throws RemoteException {
        return this.delegateLocator.getFeedItemDelegate().insert(feedItems);
    }

    public FeedItem updateFeedItem(FeedItem feedItem) throws RemoteException {
        return this.delegateLocator.getFeedItemDelegate().update(feedItem);
    }

    public List<FeedItem> updateFeedItems(List<FeedItem> feedItems) throws RemoteException {
        return this.delegateLocator.getFeedItemDelegate().update(feedItems);
    }

    public FeedItem removeFeedItem(FeedItem feedItem) throws RemoteException {
        return this.delegateLocator.getFeedItemDelegate().remove(feedItem);
    }

    public List<FeedItem> removeFeedItems(List<FeedItem> feedItems) throws RemoteException {
        return this.delegateLocator.getFeedItemDelegate().remove(feedItems);
    }

    public List<FeedMapping> getFeedMappings() throws RemoteException {
        return this.delegateLocator.getFeedMappingDelegate().get();
    }

    public List<FeedMapping> getFeedMappings(Long feedId) throws RemoteException {
        return this.delegateLocator.getFeedMappingDelegate().getByFeedId(feedId);
    }

    public FeedMapping insertFeedMapping(FeedMapping feedMapping) throws RemoteException {
        return this.delegateLocator.getFeedMappingDelegate().insert(feedMapping);
    }

    public List<FeedMapping> insertFeedMappings(List<FeedMapping> feedMappings) throws RemoteException {
        return this.delegateLocator.getFeedMappingDelegate().insert(feedMappings);
    }

    public FeedMapping updateFeedMapping(FeedMapping feedMapping) throws RemoteException {
        return this.delegateLocator.getFeedMappingDelegate().update(feedMapping);
    }

    public List<FeedMapping> updateFeedMappings(List<FeedMapping> feedMappings) throws RemoteException {
        return this.delegateLocator.getFeedMappingDelegate().update(feedMappings);
    }

    public FeedMapping removeFeedMapping(FeedMapping feedMapping) throws RemoteException {
        return this.delegateLocator.getFeedMappingDelegate().remove(feedMapping);
    }

    public List<FeedMapping> removeFeedMappings(List<FeedMapping> feedMappings) throws RemoteException {
        return this.delegateLocator.getFeedMappingDelegate().remove(feedMappings);
    }

    public List<CampaignFeed> getCampaignFeeds() throws RemoteException {
        return this.delegateLocator.getCampaignFeedDelegate().get();
    }

    public List<CampaignFeed> getCampaignFeeds(Long feedId) throws RemoteException {
        return this.delegateLocator.getCampaignFeedDelegate().getByFeedId(feedId);
    }

    public CampaignFeed insertCampaignFeed(CampaignFeed campaignFeed) throws RemoteException {
        return this.delegateLocator.getCampaignFeedDelegate().insert(campaignFeed);
    }

    public List<CampaignFeed> insertCampaignFeeds(List<CampaignFeed> campaignFeeds) throws RemoteException {
        return this.delegateLocator.getCampaignFeedDelegate().insert(campaignFeeds);
    }

    public CampaignFeed updateCampaignFeed(CampaignFeed campaignFeed) throws RemoteException {
        return this.delegateLocator.getCampaignFeedDelegate().update(campaignFeed);
    }

    public List<CampaignFeed> updateCampaignFeeds(List<CampaignFeed> campaignFeeds) throws RemoteException {
        return this.delegateLocator.getCampaignFeedDelegate().update(campaignFeeds);
    }

    public CampaignFeed removeCampaignFeed(CampaignFeed campaignFeed) throws RemoteException {
        return this.delegateLocator.getCampaignFeedDelegate().remove(campaignFeed);
    }

    public List<CampaignFeed> removeCampaignFeeds(List<CampaignFeed> campaignFeeds) throws RemoteException {
        return this.delegateLocator.getCampaignFeedDelegate().remove(campaignFeeds);
    }

    public List<AdGroupFeed> getAdGroupFeeds() throws RemoteException {
        return this.delegateLocator.getAdGroupFeedDelegate().get();
    }

    public List<AdGroupFeed> getAdGroupFeeds(Long feedId) throws RemoteException {
        return this.delegateLocator.getAdGroupFeedDelegate().getByFeedId(feedId);
    }

    public AdGroupFeed insertAdGroupFeed(AdGroupFeed adGroupFeed) throws RemoteException {
        return this.delegateLocator.getAdGroupFeedDelegate().insert(adGroupFeed);
    }

    public List<AdGroupFeed> insertAdGroupFeeds(List<AdGroupFeed> adGroupFeeds) throws RemoteException {
        return this.delegateLocator.getAdGroupFeedDelegate().insert(adGroupFeeds);
    }

    public AdGroupFeed updateAdGroupFeed(AdGroupFeed adGroupFeed) throws RemoteException {
        return this.delegateLocator.getAdGroupFeedDelegate().update(adGroupFeed);
    }

    public List<AdGroupFeed> updateAdGroupFeeds(List<AdGroupFeed> adGroupFeeds) throws RemoteException {
        return this.delegateLocator.getAdGroupFeedDelegate().update(adGroupFeeds);
    }

    public AdGroupFeed removeAdGroupFeed(AdGroupFeed adGroupFeed) throws RemoteException {
        return this.delegateLocator.getAdGroupFeedDelegate().remove(adGroupFeed);
    }

    public List<AdGroupFeed> removeAdGroupFeeds(List<AdGroupFeed> adGroupFeeds) throws RemoteException {
        return this.delegateLocator.getAdGroupFeedDelegate().remove(adGroupFeeds);
    }

    public List<Label> getLabels() throws RemoteException {
        return this.delegateLocator.getLabelDelegate().get();
    }

    public Label getLabel(Long labelId) throws RemoteException {
        return this.delegateLocator.getLabelDelegate().getByLabelId(labelId);
    }

    public List<Label> getLabelsByStatus(LabelStatus labelStatus) throws RemoteException {
        return this.delegateLocator.getLabelDelegate().getByStatus(labelStatus);
    }

    public List<Label> getLabelsByName(String labelName) throws RemoteException {
        return this.delegateLocator.getLabelDelegate().getByName(labelName);
    }

    public List<Label> insertLabels(List<Label> labels) throws RemoteException {
        return this.delegateLocator.getLabelDelegate().insert(labels);
    }

    public Label insertLabel(Label label) throws RemoteException {
        return this.delegateLocator.getLabelDelegate().insert(label);
    }

    public List<Label> removeLabels(List<Label> labels) throws RemoteException {
        return this.delegateLocator.getLabelDelegate().remove(labels);
    }

    public Label removeLabel(Label label) throws RemoteException {
        return this.delegateLocator.getLabelDelegate().remove(label);
    }
}

