/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension;

import com.google.api.ads.adwords.axis.utility.extension.DelegateLocator;
import com.google.api.ads.adwords.axis.utility.extension.ExtendedManagedCustomer;
import com.google.api.ads.adwords.axis.utility.extension.exception.UtilityLibraryException;
import com.google.api.ads.adwords.axis.utility.extension.util.AdWordsSessionUtil;
import com.google.api.ads.adwords.axis.v201506.billing.BillingAccount;
import com.google.api.ads.adwords.axis.v201506.mcm.ManagedCustomer;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.OAuthException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.common.collect.Lists;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public final class ExtendedMcc {
    private final AdWordsSession adWordsSession;
    private final DelegateLocator delegateLocator;
    private final String clientCustomerId;

    public ExtendedMcc(AdWordsSession adWordsSession) {
        this.delegateLocator = new DelegateLocator(adWordsSession);
        this.adWordsSession = this.delegateLocator.getAdWordsSession();
        this.clientCustomerId = this.delegateLocator.getClientCustomerId();
    }

    public ExtendedMcc(DelegateLocator delegateLocator) {
        this.adWordsSession = delegateLocator.getAdWordsSession();
        this.delegateLocator = delegateLocator;
        this.clientCustomerId = delegateLocator.getClientCustomerId();
    }

    public ExtendedMcc(AdWordsSession adWordsSession, String clientCustomerId) {
        this.clientCustomerId = clientCustomerId;
        this.delegateLocator = new DelegateLocator(adWordsSession, clientCustomerId);
        this.adWordsSession = this.delegateLocator.getAdWordsSession();
    }

    public ExtendedMcc(AdWordsSession adWordsSession, ManagedCustomer managedCustomer) {
        this.clientCustomerId = managedCustomer.getCustomerId().toString();
        this.delegateLocator = new DelegateLocator(adWordsSession, managedCustomer);
        this.adWordsSession = this.delegateLocator.getAdWordsSession();
    }

    public static ExtendedMcc withOAuth2FromFile() throws OAuthException, ValidationException, ConfigurationLoadException {
        return new ExtendedMcc(AdWordsSessionUtil.fromFileWithOAuth2());
    }

    public static List<ExtendedMcc> as(List<ManagedCustomer> managedCustomers, AdWordsSession adWordsSession) {
        ArrayList listExtended = Lists.newArrayListWithCapacity((int)managedCustomers.size());
        for (ManagedCustomer managedCustomer : managedCustomers) {
            listExtended.add(new ExtendedMcc(adWordsSession, managedCustomer));
        }
        return listExtended;
    }

    public AdWordsSession getAdWordsSession() {
        return this.adWordsSession;
    }

    public DelegateLocator getDelegateLocator() {
        return this.delegateLocator;
    }

    public String getClientCustomerId() {
        return this.clientCustomerId;
    }

    public List<ManagedCustomer> getMccs(List<Long> customerIds) throws RemoteException {
        return this.delegateLocator.getManagedCustomerDelegate().getByCustomerIdCanManageClients(customerIds, true);
    }

    public List<ExtendedMcc> getExtendedMccs(List<Long> customerIds) throws RemoteException {
        return ExtendedMcc.as(this.delegateLocator.getManagedCustomerDelegate().getByCustomerIdCanManageClients(customerIds, true), this.adWordsSession);
    }

    public List<ManagedCustomer> getMccs() throws RemoteException {
        return this.getMccs(null);
    }

    public List<ExtendedMcc> getExtendedMccs() throws RemoteException {
        return this.getExtendedMccs(null);
    }

    public ManagedCustomer getMcc(Long customerId) throws RemoteException {
        ManagedCustomer mcc = this.getManagedCustomer(customerId);
        if (mcc.getCanManageClients().booleanValue()) {
            return mcc;
        }
        throw new UtilityLibraryException("Error: result empty for getMcc(Long customerId)");
    }

    public ExtendedMcc getExtendedMcc(Long customerId) throws RemoteException {
        ExtendedManagedCustomer mcc = this.getExtendedManagedCustomer(customerId);
        if (mcc.getManagedCustomer().getCanManageClients().booleanValue()) {
            return new ExtendedMcc(this.adWordsSession, mcc.getManagedCustomer());
        }
        throw new UtilityLibraryException("Error: result empty for getMcc(Long customerId)");
    }

    public List<ManagedCustomer> getManagedCustomers(List<Long> customerIds) throws RemoteException {
        return this.delegateLocator.getManagedCustomerDelegate().getByCustomerIdCanManageClients(customerIds, false);
    }

    public List<ExtendedManagedCustomer> getExtendedManagedCustomers(List<Long> customerIds) throws RemoteException {
        return ExtendedManagedCustomer.as(this.delegateLocator.getManagedCustomerDelegate().getByCustomerIdCanManageClients(customerIds, false), this.adWordsSession);
    }

    public List<ManagedCustomer> getManagedCustomers() throws RemoteException {
        return this.getManagedCustomers(null);
    }

    public List<ManagedCustomer> getManagedCustomers(int startIndex, int numberResults) throws RemoteException {
        return this.delegateLocator.getManagedCustomerDelegate().get(startIndex, numberResults);
    }

    public List<ExtendedManagedCustomer> getExtendedManagedCustomers() throws RemoteException {
        return this.getExtendedManagedCustomers(null);
    }

    public List<ExtendedManagedCustomer> getExtendedManagedCustomers(int startIndex, int numberResults) throws RemoteException {
        return ExtendedManagedCustomer.as(this.getManagedCustomers(startIndex, numberResults), this.adWordsSession);
    }

    public ManagedCustomer getManagedCustomer(Long customerId) throws RemoteException {
        return this.getManagedCustomer(String.valueOf(customerId));
    }

    public ManagedCustomer getManagedCustomer(String customerId) throws RemoteException {
        return this.delegateLocator.getManagedCustomerDelegate().getByCustomerId(customerId);
    }

    public ExtendedManagedCustomer getExtendedManagedCustomer(Long customerId) throws RemoteException {
        return new ExtendedManagedCustomer(this.delegateLocator.getManagedCustomerDelegate().getByCustomerId(customerId), this.adWordsSession);
    }

    public List<ExtendedManagedCustomer> insertManagedCustomers(List<ManagedCustomer> apiManagedCustomers) throws RemoteException {
        return ExtendedManagedCustomer.as(this.delegateLocator.getManagedCustomerDelegate().insert(apiManagedCustomers), this.adWordsSession);
    }

    public ExtendedManagedCustomer insertManagedCustomer(ManagedCustomer apiManagedCustomer) throws RemoteException {
        return new ExtendedManagedCustomer(this.delegateLocator.getManagedCustomerDelegate().insert(apiManagedCustomer), this.adWordsSession);
    }

    public ExtendedManagedCustomer insertManagedCustomer(String name, String companyName, String dateTimeZone, String currencyCode) throws RemoteException {
        ManagedCustomer newManagedCustomer = new ManagedCustomer();
        newManagedCustomer.setName(name);
        newManagedCustomer.setCompanyName(companyName);
        newManagedCustomer.setDateTimeZone(dateTimeZone);
        newManagedCustomer.setCurrencyCode(currencyCode);
        return new ExtendedManagedCustomer(this.delegateLocator.getManagedCustomerDelegate().insert(newManagedCustomer), this.adWordsSession);
    }

    public List<BillingAccount> getBillingAccounts() throws RemoteException {
        return this.delegateLocator.getBudgetOrderDelegate().getBillingAccounts();
    }
}

