/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.delegates;

import com.google.api.ads.adwords.axis.factory.AdWordsServices;
import com.google.api.ads.adwords.axis.utility.extension.util.AdWordsSessionUtil;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.common.lib.client.AdsSession;

public abstract class AbstractBaseDelegate<S> {
    static final int MAX_RETRY_COUNT = 3;
    private final AdWordsSession adWordsSession;
    private final AdWordsServices adWordsServices = new AdWordsServices();
    private final S service;
    final Class<?> classS;

    protected AbstractBaseDelegate(AdWordsSession adWordsSession, Class<S> classS) {
        this.adWordsSession = AdWordsSessionUtil.copyIfNeededWithUtilityUserAgent(adWordsSession);
        this.classS = classS;
        this.service = this.adWordsServices.get((AdsSession)adWordsSession, classS);
    }

    protected AbstractBaseDelegate(AdWordsSession adWordsSession, S service) {
        this.classS = service.getClass();
        this.adWordsSession = AdWordsSessionUtil.copyIfNeededWithUtilityUserAgent(adWordsSession);
        this.service = service;
    }

    protected AdWordsSession getAdWordsSession() {
        return this.adWordsSession;
    }

    public S getService() {
        return this.service;
    }
}

