/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.delegates;

import com.google.api.ads.adwords.axis.utility.extension.delegates.AbstractBaseDelegate;
import com.google.api.ads.adwords.axis.utility.extension.util.ListUtil;
import com.google.api.ads.adwords.axis.utility.extension.util.ReflectionUtil;
import com.google.api.ads.adwords.axis.utility.extension.util.SelectorFields;
import com.google.api.ads.adwords.axis.utils.v201506.SelectorBuilder;
import com.google.api.ads.adwords.axis.v201506.cm.Selector;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Array;
import java.rmi.RemoteException;
import java.util.List;

public abstract class AbstractGetDelegate<T, S>
extends AbstractBaseDelegate<S> {
    private final Class<T> classT;
    private final String[] fields;
    private String getMethodName = "get";

    protected AbstractGetDelegate(AdWordsSession adWordsSession, Class<T> classT, Class<S> classS) {
        super(adWordsSession, classS);
        this.classT = classT;
        this.fields = null;
    }

    @VisibleForTesting
    protected AbstractGetDelegate(AdWordsSession adWordsSession, Class<T> classT, S service) {
        super(adWordsSession, service);
        this.classT = classT;
        this.fields = null;
    }

    protected AbstractGetDelegate(AdWordsSession adWordsSession, Class<T> classT, Class<S> classS, List<? extends SelectorFields.FieldType<T>> selectorFields) {
        super(adWordsSession, classS);
        this.classT = classT;
        this.fields = SelectorFields.getFields(selectorFields);
    }

    protected AbstractGetDelegate(AdWordsSession adWordsSession, Class<T> classT, S service, List<? extends SelectorFields.FieldType<T>> selectorFields) {
        super(adWordsSession, service);
        this.classT = classT;
        this.fields = SelectorFields.getFields(selectorFields);
    }

    public Class<T> getClassT() {
        return this.classT;
    }

    protected void setGetMethodName(String getMethodName) {
        this.getMethodName = getMethodName;
    }

    public List<T> get(Selector selector) throws RemoteException {
        Class<?> classArrayT = Array.newInstance(this.getClassT(), 0).getClass();
        Object[] array = (Object[])classArrayT.cast(ReflectionUtil.invokeCount("getEntries", this.getPage(selector), selector.getClass(), 1));
        return ListUtil.asList(array);
    }

    protected Object getPage(Selector selector) throws RemoteException {
        return ReflectionUtil.invokeCount(this.getMethodName, this.getService(), this.classS, selector, 3);
    }

    protected SelectorBuilder createSelectorBuilder() {
        return new SelectorBuilder().fields(this.fields);
    }

    private SelectorBuilder createSelectorBuilder(SelectorFields.FieldType<T> selectorField, List<?> fieldValues, int startIndex, int numberResults) {
        SelectorBuilder selectorBuilder = this.createSelectorBuilder().in(selectorField.getField(), ListUtil.asStringArray(fieldValues)).offset(startIndex).limit(numberResults);
        return selectorBuilder;
    }

    private SelectorBuilder createSelectorBuilder(SelectorFields.FieldType<T> selectorField, List<?> fieldValues) {
        SelectorBuilder selectorBuilder = this.createSelectorBuilder().in(selectorField.getField(), ListUtil.asStringArray(fieldValues));
        return selectorBuilder;
    }

    public List<T> get() throws RemoteException {
        return this.get(this.createSelectorBuilder().build());
    }

    public List<T> get(int startIndex, int numberResults) throws RemoteException {
        SelectorBuilder builder = this.createSelectorBuilder().offset(startIndex).limit(numberResults);
        return this.get(builder.build());
    }

    protected T getOneByField(SelectorFields.FieldType<T> selectorField, Object fieldValue) throws RemoteException {
        List<T> list = this.getByField(selectorField, fieldValue);
        if (!list.isEmpty()) {
            return (T)Iterables.getOnlyElement(list);
        }
        return null;
    }

    protected List<T> getByField(SelectorFields.FieldType<T> selectorField, Object fieldValue) throws RemoteException {
        return this.get(this.createSelectorBuilder(selectorField, (List<?>)ImmutableList.of((Object)fieldValue)).build());
    }

    protected List<T> getByField(SelectorFields.FieldType<T> selectorField, List<Long> fieldValues) throws RemoteException {
        return this.get(this.createSelectorBuilder(selectorField, fieldValues).build());
    }

    protected List<T> getByField(SelectorFields.FieldType<T> selectorField, long fieldValue, int startIndex, int numberResults) throws RemoteException {
        return this.get(this.createSelectorBuilder(selectorField, (List<?>)ImmutableList.of((Object)fieldValue), startIndex, numberResults).build());
    }

    protected List<T> getByField(SelectorFields.FieldType<T> selectorField, String fieldValue, int startIndex, int numberResults) throws RemoteException {
        return this.get(this.createSelectorBuilder(selectorField, (List<?>)ImmutableList.of((Object)fieldValue), startIndex, numberResults).build());
    }

    protected List<T> getByFieldContainsAny(SelectorFields.FieldType<T> selectorField, List<Long> fieldValues) throws RemoteException {
        return this.get(this.createSelectorBuilder().containsAny(selectorField.getField(), ListUtil.asStringArray(fieldValues)).build());
    }
}

