/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.delegates;

import com.google.api.ads.adwords.axis.utility.extension.delegates.AbstractGetDelegate;
import com.google.api.ads.adwords.axis.utility.extension.exception.UtilityLibraryException;
import com.google.api.ads.adwords.axis.utility.extension.util.ListUtil;
import com.google.api.ads.adwords.axis.utility.extension.util.ReflectionUtil;
import com.google.api.ads.adwords.axis.utility.extension.util.SelectorFields;
import com.google.api.ads.adwords.axis.v201506.cm.ListReturnValue;
import com.google.api.ads.adwords.axis.v201506.cm.Operation;
import com.google.api.ads.adwords.axis.v201506.cm.Operator;
import com.google.api.ads.adwords.axis.v201506.mcm.ManagedCustomerReturnValue;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import java.lang.reflect.Array;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractGetMutateDelegate<T, OperationT extends Operation, S>
extends AbstractGetDelegate<T, S> {
    private static final String MUTATE = "mutate";
    private final Class<OperationT> classOperationT;
    private final String mutateMethodName;

    protected AbstractGetMutateDelegate(AdWordsSession adWordsSession, Class<T> classT, Class<OperationT> classOperationT, Class<S> classS) {
        super(adWordsSession, classT, classS);
        this.classOperationT = classOperationT;
        this.mutateMethodName = MUTATE;
    }

    protected AbstractGetMutateDelegate(AdWordsSession adWordsSession, Class<T> classT, Class<OperationT> classOperationT, Class<S> classS, String mutateMethodName) {
        super(adWordsSession, classT, classS);
        this.classOperationT = classOperationT;
        this.mutateMethodName = mutateMethodName;
    }

    @VisibleForTesting
    protected AbstractGetMutateDelegate(AdWordsSession adWordsSession, Class<T> classT, Class<OperationT> classOperationT, S service) {
        super(adWordsSession, classT, service);
        this.classOperationT = classOperationT;
        this.mutateMethodName = MUTATE;
    }

    protected AbstractGetMutateDelegate(AdWordsSession adWordsSession, Class<T> classT, Class<OperationT> classOperationT, S service, String mutateMethodName) {
        super(adWordsSession, classT, service);
        this.classOperationT = classOperationT;
        this.mutateMethodName = mutateMethodName;
    }

    protected AbstractGetMutateDelegate(AdWordsSession adWordsSession, List<? extends SelectorFields.FieldType<T>> selectorFields, Class<T> classT, Class<OperationT> classOperationT, Class<S> classS) {
        super(adWordsSession, classT, classS, selectorFields);
        this.classOperationT = classOperationT;
        this.mutateMethodName = MUTATE;
    }

    protected AbstractGetMutateDelegate(AdWordsSession adWordsSession, List<? extends SelectorFields.FieldType<T>> selectorFields, Class<T> classT, Class<OperationT> classOperationT, Class<S> classS, String mutateMethodName) {
        super(adWordsSession, classT, classS, selectorFields);
        this.classOperationT = classOperationT;
        this.mutateMethodName = mutateMethodName;
    }

    protected AbstractGetMutateDelegate(AdWordsSession adWordsSession, List<? extends SelectorFields.FieldType<T>> selectorFields, Class<T> classT, Class<OperationT> classOperationT, S service) {
        super(adWordsSession, classT, service, selectorFields);
        this.classOperationT = classOperationT;
        this.mutateMethodName = MUTATE;
    }

    protected AbstractGetMutateDelegate(AdWordsSession adWordsSession, List<? extends SelectorFields.FieldType<T>> selectorFields, Class<T> classT, Class<OperationT> classOperationT, S service, String mutateMethodName) {
        super(adWordsSession, classT, service, selectorFields);
        this.classOperationT = classOperationT;
        this.mutateMethodName = mutateMethodName;
    }

    private List<T> getValue(Object object) throws RemoteException {
        Class<?> classArrayT = Array.newInstance(this.getClassT(), 0).getClass();
        if (object instanceof ListReturnValue) {
            Object[] array = (Object[])classArrayT.cast(ReflectionUtil.invokeCount("getValue", object, object.getClass(), 1));
            return ListUtil.asList(array);
        }
        if (object instanceof ManagedCustomerReturnValue) {
            return ListUtil.asList((Object[])classArrayT.cast(((ManagedCustomerReturnValue)object).getValue()));
        }
        if (object.getClass().isArray() && object.getClass().getComponentType().equals(this.getClassT())) {
            return ListUtil.asList((Object[])classArrayT.cast(object));
        }
        String string = String.valueOf(object.getClass().getName());
        throw new UtilityLibraryException(new StringBuilder(60 + String.valueOf(string).length()).append("Error during reflection for ").append(string).append(".getValue(), input not supported").toString());
    }

    private List<OperationT> createOperations(List<T> list, Operator operator) {
        ArrayList operations = Lists.newArrayList();
        for (T t : list) {
            try {
                Operation operation = (Operation)this.classOperationT.newInstance();
                ReflectionUtil.invokeCount("setOperand", operation, this.classOperationT, t, this.getClassT(), 1);
                operation.setOperator(operator);
                operations.add(operation);
            }
            catch (Exception e) {
                String string = String.valueOf(this.getClassT().getName());
                throw new UtilityLibraryException(new StringBuilder(42 + String.valueOf(string).length()).append("Error during reflection for ").append(string).append(".setOperand(t)").toString(), e);
            }
        }
        return operations;
    }

    protected Object mutate(List<OperationT> operations) throws RemoteException {
        Operation[] operationsArray = (Operation[])operations.toArray(ObjectArrays.newArray(this.classOperationT, (int)operations.size()));
        return ReflectionUtil.invokeCount(this.mutateMethodName, this.getService(), this.classS, operationsArray, 3);
    }

    public List<T> insert(List<T> list) throws RemoteException {
        return this.getValue(this.mutate(this.createOperations(list, Operator.ADD)));
    }

    public T insert(T object) throws RemoteException {
        return (T)Iterables.getOnlyElement(this.getValue(this.mutate(this.createOperations((List<T>)ImmutableList.of(object), Operator.ADD))));
    }

    public List<T> update(List<T> list) throws RemoteException {
        return this.getValue(this.mutate(this.createOperations(list, Operator.SET)));
    }

    public T update(T object) throws RemoteException {
        return (T)Iterables.getOnlyElement(this.getValue(this.mutate(this.createOperations((List<T>)ImmutableList.of(object), Operator.SET))));
    }

    public List<T> remove(List<T> list) throws RemoteException {
        return this.getValue(this.mutate(this.createOperations(list, Operator.REMOVE)));
    }

    public T remove(T object) throws RemoteException {
        return (T)Iterables.getOnlyElement(this.getValue(this.mutate(this.createOperations((List<T>)ImmutableList.of(object), Operator.REMOVE))));
    }
}

