/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.delegates;

import com.google.api.ads.adwords.axis.utility.extension.delegates.AbstractGetMutateDelegate;
import com.google.api.ads.adwords.axis.utility.extension.delegates.AdGroupAdLabelDelegate;
import com.google.api.ads.adwords.axis.utility.extension.util.SelectorFields;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupAd;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupAdLabel;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupAdOperation;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupAdServiceInterface;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.common.annotations.VisibleForTesting;
import java.rmi.RemoteException;
import java.util.List;

public final class AdGroupAdDelegate
extends AbstractGetMutateDelegate<AdGroupAd, AdGroupAdOperation, AdGroupAdServiceInterface> {
    private final AdGroupAdLabelDelegate adGroupAdLabelDelegate;

    public AdGroupAdDelegate(AdWordsSession adWordsSession) {
        super(adWordsSession, SelectorFields.AdGroupAd.all(), AdGroupAd.class, AdGroupAdOperation.class, AdGroupAdServiceInterface.class);
        this.adGroupAdLabelDelegate = new AdGroupAdLabelDelegate(adWordsSession, (AdGroupAdServiceInterface)this.getService());
    }

    @VisibleForTesting
    AdGroupAdDelegate(AdWordsSession adWordsSession, AdGroupAdServiceInterface service) {
        super(adWordsSession, SelectorFields.AdGroupAd.all(), AdGroupAd.class, AdGroupAdOperation.class, service);
        this.adGroupAdLabelDelegate = new AdGroupAdLabelDelegate(adWordsSession, service);
    }

    public AdGroupAdDelegate(AdWordsSession adWordsSession, List<SelectorFields.AdGroupAd> selectorFields) {
        super(adWordsSession, selectorFields, AdGroupAd.class, AdGroupAdOperation.class, AdGroupAdServiceInterface.class);
        this.adGroupAdLabelDelegate = new AdGroupAdLabelDelegate(adWordsSession, (AdGroupAdServiceInterface)this.getService());
    }

    public AdGroupAd getByAdId(Long adId) throws RemoteException {
        return this.getOneByField(SelectorFields.AdGroupAd.ID, adId);
    }

    public List<AdGroupAd> getByAdGroupId(List<Long> adGroupIds) throws RemoteException {
        return this.getByField(SelectorFields.AdGroupAd.ADGROUP_ID, adGroupIds);
    }

    public List<AdGroupAd> getByAdGroupId(Long adGroupId) throws RemoteException {
        return this.getByField(SelectorFields.AdGroupAd.ADGROUP_ID, adGroupId);
    }

    public List<AdGroupAd> getByAdGroupId(Long adGroupId, int startIndex, int numberResults) throws RemoteException {
        return this.getByField(SelectorFields.AdGroupAd.ADGROUP_ID, adGroupId, startIndex, numberResults);
    }

    public List<AdGroupAd> getByLabelIds(List<Long> labelIds) throws RemoteException {
        return this.getByFieldContainsAny(SelectorFields.AdGroupAd.LABELS, labelIds);
    }

    public List<AdGroupAdLabel> insertAdGroupAdLabel(List<AdGroupAdLabel> adGroupAdLabels) throws RemoteException {
        return this.adGroupAdLabelDelegate.insert(adGroupAdLabels);
    }

    public AdGroupAdLabel insertAdGroupAdLabel(AdGroupAdLabel adGroupAdLabel) throws RemoteException {
        return this.adGroupAdLabelDelegate.insert(adGroupAdLabel);
    }

    public List<AdGroupAdLabel> removeAdGroupAdLabel(List<AdGroupAdLabel> adGroupAdLabels) throws RemoteException {
        return this.adGroupAdLabelDelegate.remove(adGroupAdLabels);
    }

    public AdGroupAdLabel removeAdGroupAdLabel(AdGroupAdLabel adGroupAdLabel) throws RemoteException {
        return this.adGroupAdLabelDelegate.remove(adGroupAdLabel);
    }
}

