/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.delegates;

import com.google.api.ads.adwords.axis.utility.extension.delegates.AbstractGetMutateDelegate;
import com.google.api.ads.adwords.axis.utility.extension.delegates.AdGroupCriterionLabelDelegate;
import com.google.api.ads.adwords.axis.utility.extension.util.SelectorFields;
import com.google.api.ads.adwords.axis.utils.v201506.SelectorBuilder;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupCriterion;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupCriterionLabel;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupCriterionOperation;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupCriterionServiceInterface;
import com.google.api.ads.adwords.axis.v201506.cm.CriterionType;
import com.google.api.ads.adwords.axis.v201506.cm.CriterionUse;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import java.rmi.RemoteException;
import java.util.List;

public final class AdGroupCriterionDelegate
extends AbstractGetMutateDelegate<AdGroupCriterion, AdGroupCriterionOperation, AdGroupCriterionServiceInterface> {
    private final AdGroupCriterionLabelDelegate adGroupCriterionLabelDelegate;

    public AdGroupCriterionDelegate(AdWordsSession adWordsSession, boolean includeBetaFields) {
        super(adWordsSession, SelectorFields.AdGroupCriterion.all(includeBetaFields), AdGroupCriterion.class, AdGroupCriterionOperation.class, AdGroupCriterionServiceInterface.class);
        this.adGroupCriterionLabelDelegate = new AdGroupCriterionLabelDelegate(adWordsSession, (AdGroupCriterionServiceInterface)this.getService());
    }

    AdGroupCriterionDelegate(AdWordsSession adWordsSession, AdGroupCriterionServiceInterface service, boolean includeBetaFields) {
        super(adWordsSession, SelectorFields.AdGroupCriterion.all(includeBetaFields), AdGroupCriterion.class, AdGroupCriterionOperation.class, service);
        this.adGroupCriterionLabelDelegate = new AdGroupCriterionLabelDelegate(adWordsSession, service);
    }

    public AdGroupCriterionDelegate(AdWordsSession adWordsSession, List<SelectorFields.AdGroupCriterion> selectorFields) {
        super(adWordsSession, selectorFields, AdGroupCriterion.class, AdGroupCriterionOperation.class, AdGroupCriterionServiceInterface.class);
        this.adGroupCriterionLabelDelegate = new AdGroupCriterionLabelDelegate(adWordsSession, (AdGroupCriterionServiceInterface)this.getService());
    }

    public List<AdGroupCriterion> getByAdGroupIdCriterionId(Long adGroupId, Long criterionId) throws RemoteException {
        SelectorBuilder builder = this.createSelectorBuilder().equals(SelectorFields.AdGroupCriterion.ADGROUP_ID.getField(), String.valueOf(adGroupId)).equals(SelectorFields.AdGroupCriterion.ID.getField(), String.valueOf(criterionId));
        return this.get(builder.build());
    }

    public List<AdGroupCriterion> getByAdGroupId(List<Long> adGroupIds) throws RemoteException {
        return this.getByField(SelectorFields.AdGroupCriterion.ADGROUP_ID, adGroupIds);
    }

    public List<AdGroupCriterion> getByAdGroupId(Long adGroupId) throws RemoteException {
        return this.getByField(SelectorFields.AdGroupCriterion.ADGROUP_ID, adGroupId);
    }

    public List<AdGroupCriterion> getByAdGroupId(Long adGroupId, int startIndex, int numberResults) throws RemoteException {
        return this.getByField(SelectorFields.AdGroupCriterion.ADGROUP_ID, adGroupId, startIndex, numberResults);
    }

    public List<AdGroupCriterion> getByCriterionUse(CriterionUse criterionUse) throws RemoteException {
        return this.getByField(SelectorFields.AdGroupCriterion.CRITERION_USE, criterionUse.getValue());
    }

    public List<AdGroupCriterion> getByCriterionType(CriterionType criterionType) throws RemoteException {
        return this.getByField(SelectorFields.AdGroupCriterion.CRITERIA_TYPE, criterionType.getValue());
    }

    public List<AdGroupCriterion> getByCriterionUseCriterionType(CriterionUse criterionUse, CriterionType criterionType) throws RemoteException {
        SelectorBuilder builder = this.createSelectorBuilder().equals(SelectorFields.AdGroupCriterion.CRITERION_USE.getField(), criterionUse.getValue()).equals(SelectorFields.AdGroupCriterion.CRITERIA_TYPE.getField(), criterionType.getValue());
        return this.get(builder.build());
    }

    public List<AdGroupCriterion> getByAdGroupIdCriterionUse(Long adGroupId, CriterionUse criterionUse) throws RemoteException {
        SelectorBuilder builder = this.createSelectorBuilder().equals(SelectorFields.AdGroupCriterion.ADGROUP_ID.getField(), String.valueOf(adGroupId)).equals(SelectorFields.AdGroupCriterion.CRITERION_USE.getField(), criterionUse.getValue());
        return this.get(builder.build());
    }

    public List<AdGroupCriterion> getByAdGroupIdCriterionType(Long adGroupId, CriterionType criterionType) throws RemoteException {
        SelectorBuilder builder = this.createSelectorBuilder().equals(SelectorFields.AdGroupCriterion.ADGROUP_ID.getField(), String.valueOf(adGroupId)).equals(SelectorFields.AdGroupCriterion.CRITERIA_TYPE.getField(), criterionType.getValue());
        return this.get(builder.build());
    }

    public List<AdGroupCriterion> getByAdGroupIdCriterionUseCriterionType(Long adGroupId, CriterionUse criterionUse, CriterionType criterionType) throws RemoteException {
        SelectorBuilder builder = this.createSelectorBuilder().equals(SelectorFields.AdGroupCriterion.ADGROUP_ID.getField(), String.valueOf(adGroupId)).equals(SelectorFields.AdGroupCriterion.CRITERION_USE.getField(), criterionUse.getValue()).equals(SelectorFields.AdGroupCriterion.CRITERIA_TYPE.getField(), criterionType.getValue());
        return this.get(builder.build());
    }

    public List<AdGroupCriterion> getByLabelIds(List<Long> labelIds) throws RemoteException {
        return this.getByFieldContainsAny(SelectorFields.AdGroupCriterion.LABELS, labelIds);
    }

    public List<AdGroupCriterionLabel> insertAdGroupCriterionLabel(List<AdGroupCriterionLabel> adGroupCriterionLabels) throws RemoteException {
        return this.adGroupCriterionLabelDelegate.insert(adGroupCriterionLabels);
    }

    public AdGroupCriterionLabel insertAdGroupCriterionLabel(AdGroupCriterionLabel adGroupCriterionLabel) throws RemoteException {
        return this.adGroupCriterionLabelDelegate.insert(adGroupCriterionLabel);
    }

    public List<AdGroupCriterionLabel> removeAdGroupCriterionLabel(List<AdGroupCriterionLabel> adGroupCriterionLabels) throws RemoteException {
        return this.adGroupCriterionLabelDelegate.remove(adGroupCriterionLabels);
    }

    public AdGroupCriterionLabel removeAdGroupCriterionLabel(AdGroupCriterionLabel adGroupCriterionLabel) throws RemoteException {
        return this.adGroupCriterionLabelDelegate.remove(adGroupCriterionLabel);
    }
}

