/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.delegates;

import com.google.api.ads.adwords.axis.utility.extension.delegates.AbstractGetMutateDelegate;
import com.google.api.ads.adwords.axis.utility.extension.delegates.AdGroupLabelDelegate;
import com.google.api.ads.adwords.axis.utility.extension.util.SelectorFields;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroup;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupLabel;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupOperation;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupServiceInterface;
import com.google.api.ads.adwords.axis.v201506.cm.AdGroupStatus;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.common.annotations.VisibleForTesting;
import java.rmi.RemoteException;
import java.util.List;

public final class AdGroupDelegate
extends AbstractGetMutateDelegate<AdGroup, AdGroupOperation, AdGroupServiceInterface> {
    private final AdGroupLabelDelegate adGroupLabelDelegate;

    public AdGroupDelegate(AdWordsSession adWordsSession) {
        super(adWordsSession, SelectorFields.AdGroup.all(), AdGroup.class, AdGroupOperation.class, AdGroupServiceInterface.class);
        this.adGroupLabelDelegate = new AdGroupLabelDelegate(adWordsSession, (AdGroupServiceInterface)this.getService());
    }

    @VisibleForTesting
    AdGroupDelegate(AdWordsSession adWordsSession, AdGroupServiceInterface service) {
        super(adWordsSession, SelectorFields.AdGroup.all(), AdGroup.class, AdGroupOperation.class, service);
        this.adGroupLabelDelegate = new AdGroupLabelDelegate(adWordsSession, service);
    }

    public AdGroupDelegate(AdWordsSession adWordsSession, List<SelectorFields.AdGroup> selectorFields) {
        super(adWordsSession, selectorFields, AdGroup.class, AdGroupOperation.class, AdGroupServiceInterface.class);
        this.adGroupLabelDelegate = new AdGroupLabelDelegate(adWordsSession, (AdGroupServiceInterface)this.getService());
    }

    public AdGroup getByAdGroupId(Long adGroupId) throws RemoteException {
        return this.getOneByField(SelectorFields.AdGroup.ID, adGroupId);
    }

    public List<AdGroup> getByCampaignId(List<Long> campaignIds) throws RemoteException {
        return this.getByField(SelectorFields.AdGroup.CAMPAIGN_ID, campaignIds);
    }

    public List<AdGroup> getByCampaignId(Long campaignId) throws RemoteException {
        return this.getByField(SelectorFields.AdGroup.CAMPAIGN_ID, campaignId);
    }

    public List<AdGroup> getByCampaignId(Long campaignId, int startIndex, int numberResults) throws RemoteException {
        return this.getByField(SelectorFields.AdGroup.CAMPAIGN_ID, campaignId, startIndex, numberResults);
    }

    public List<AdGroup> getByStatus(AdGroupStatus adGroupStatus) throws RemoteException {
        return this.getByField(SelectorFields.AdGroup.STATUS, adGroupStatus);
    }

    public List<AdGroup> getByStatus(AdGroupStatus adGroupStatus, int startIndex, int numberResults) throws RemoteException {
        return this.getByField(SelectorFields.AdGroup.STATUS, adGroupStatus.getValue(), startIndex, numberResults);
    }

    public List<AdGroup> getByLabelIds(List<Long> labelIds) throws RemoteException {
        return this.getByFieldContainsAny(SelectorFields.AdGroup.LABELS, labelIds);
    }

    @Override
    public List<AdGroup> remove(List<AdGroup> list) throws RemoteException {
        for (AdGroup adGroup : list) {
            adGroup.setStatus(AdGroupStatus.REMOVED);
        }
        return this.update(list);
    }

    @Override
    public AdGroup remove(AdGroup adGroup) throws RemoteException {
        adGroup.setStatus(AdGroupStatus.REMOVED);
        return this.update(adGroup);
    }

    public List<AdGroupLabel> insertAdGroupLabel(List<AdGroupLabel> adGroupLabels) throws RemoteException {
        return this.adGroupLabelDelegate.insert(adGroupLabels);
    }

    public AdGroupLabel insertAdGroupLabel(AdGroupLabel adGroupLabel) throws RemoteException {
        return this.adGroupLabelDelegate.insert(adGroupLabel);
    }

    public List<AdGroupLabel> removeAdGroupLabel(List<AdGroupLabel> adGroupLabels) throws RemoteException {
        return this.adGroupLabelDelegate.remove(adGroupLabels);
    }

    public AdGroupLabel removeAdGroupLabel(AdGroupLabel adGroupLabel) throws RemoteException {
        return this.adGroupLabelDelegate.remove(adGroupLabel);
    }
}

