/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.delegates;

import com.google.api.ads.adwords.axis.utility.extension.delegates.AbstractGetMutateDelegate;
import com.google.api.ads.adwords.axis.utility.extension.util.ListUtil;
import com.google.api.ads.adwords.axis.utility.extension.util.SelectorFields;
import com.google.api.ads.adwords.axis.v201506.billing.BillingAccount;
import com.google.api.ads.adwords.axis.v201506.billing.BudgetOrder;
import com.google.api.ads.adwords.axis.v201506.billing.BudgetOrderOperation;
import com.google.api.ads.adwords.axis.v201506.billing.BudgetOrderServiceInterface;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.common.annotations.VisibleForTesting;
import java.rmi.RemoteException;
import java.util.List;

public final class BudgetOrderDelegate
extends AbstractGetMutateDelegate<BudgetOrder, BudgetOrderOperation, BudgetOrderServiceInterface> {
    public BudgetOrderDelegate(AdWordsSession adWordsSession, boolean newBilling) {
        super(adWordsSession, SelectorFields.BudgetOrder.all(newBilling), BudgetOrder.class, BudgetOrderOperation.class, BudgetOrderServiceInterface.class);
    }

    @VisibleForTesting
    BudgetOrderDelegate(AdWordsSession adWordsSession, BudgetOrderServiceInterface service, boolean newBilling) {
        super(adWordsSession, SelectorFields.BudgetOrder.all(newBilling), BudgetOrder.class, BudgetOrderOperation.class, service);
    }

    public BudgetOrderDelegate(AdWordsSession adWordsSession, List<SelectorFields.BudgetOrder> selectorFields) {
        super(adWordsSession, selectorFields, BudgetOrder.class, BudgetOrderOperation.class, BudgetOrderServiceInterface.class);
    }

    public List<BillingAccount> getBillingAccounts() throws RemoteException {
        return ListUtil.asList(((BudgetOrderServiceInterface)this.getService()).getBillingAccounts());
    }

    public BudgetOrder getById(Long id) throws RemoteException {
        return this.getOneByField(SelectorFields.BudgetOrder.ID, id);
    }

    public List<BudgetOrder> getByBillingAccountId(Long billingAccountId) throws RemoteException {
        return this.getByField(SelectorFields.BudgetOrder.BILLING_ACCOUNT_ID, billingAccountId);
    }
}

