/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.delegates;

import com.google.api.ads.adwords.axis.utility.extension.delegates.AbstractGetMutateDelegate;
import com.google.api.ads.adwords.axis.utility.extension.delegates.CampaignLabelDelegate;
import com.google.api.ads.adwords.axis.utility.extension.util.SelectorFields;
import com.google.api.ads.adwords.axis.v201506.cm.Campaign;
import com.google.api.ads.adwords.axis.v201506.cm.CampaignLabel;
import com.google.api.ads.adwords.axis.v201506.cm.CampaignOperation;
import com.google.api.ads.adwords.axis.v201506.cm.CampaignServiceInterface;
import com.google.api.ads.adwords.axis.v201506.cm.CampaignStatus;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.common.annotations.VisibleForTesting;
import java.rmi.RemoteException;
import java.util.List;

public final class CampaignDelegate
extends AbstractGetMutateDelegate<Campaign, CampaignOperation, CampaignServiceInterface> {
    private final CampaignLabelDelegate campaignLabelDelegate;

    public CampaignDelegate(AdWordsSession adWordsSession) {
        super(adWordsSession, SelectorFields.Campaign.all(), Campaign.class, CampaignOperation.class, CampaignServiceInterface.class);
        this.campaignLabelDelegate = new CampaignLabelDelegate(adWordsSession, (CampaignServiceInterface)this.getService());
    }

    @VisibleForTesting
    public CampaignDelegate(AdWordsSession adWordsSession, CampaignServiceInterface service) {
        super(adWordsSession, SelectorFields.Campaign.all(), Campaign.class, CampaignOperation.class, service);
        this.campaignLabelDelegate = new CampaignLabelDelegate(adWordsSession, service);
    }

    public CampaignDelegate(AdWordsSession adWordsSession, List<SelectorFields.Campaign> selectorFields) {
        super(adWordsSession, selectorFields, Campaign.class, CampaignOperation.class, CampaignServiceInterface.class);
        this.campaignLabelDelegate = new CampaignLabelDelegate(adWordsSession, (CampaignServiceInterface)this.getService());
    }

    public List<Campaign> getByCampaignId(List<Long> campaignIds) throws RemoteException {
        return this.getByField(SelectorFields.Campaign.ID, campaignIds);
    }

    public Campaign getByCampaignId(Long campaignId) throws RemoteException {
        return this.getOneByField(SelectorFields.Campaign.ID, campaignId);
    }

    public List<Campaign> getByStatus(CampaignStatus campaignStatus) throws RemoteException {
        return this.getByField(SelectorFields.Campaign.STATUS, campaignStatus);
    }

    public List<Campaign> getByLabelIds(List<Long> labelIds) throws RemoteException {
        return this.getByFieldContainsAny(SelectorFields.Campaign.LABELS, labelIds);
    }

    @Override
    public List<Campaign> remove(List<Campaign> list) throws RemoteException {
        for (Campaign campaign : list) {
            campaign.setStatus(CampaignStatus.REMOVED);
        }
        return this.update(list);
    }

    @Override
    public Campaign remove(Campaign campaign) throws RemoteException {
        campaign.setStatus(CampaignStatus.REMOVED);
        return this.update(campaign);
    }

    public List<CampaignLabel> insertCampaignLabel(List<CampaignLabel> campaignLabels) throws RemoteException {
        return this.campaignLabelDelegate.insert(campaignLabels);
    }

    public CampaignLabel insertCampaignLabel(CampaignLabel campaignLabel) throws RemoteException {
        return this.campaignLabelDelegate.insert(campaignLabel);
    }

    public List<CampaignLabel> removeCampaignLabel(List<CampaignLabel> campaignLabels) throws RemoteException {
        return this.campaignLabelDelegate.remove(campaignLabels);
    }

    public CampaignLabel removeCampaignLabel(CampaignLabel campaignLabel) throws RemoteException {
        return this.campaignLabelDelegate.remove(campaignLabel);
    }
}

