/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.delegates;

import com.google.api.ads.adwords.axis.utility.extension.delegates.AbstractBaseDelegate;
import com.google.api.ads.adwords.axis.v201506.ch.CampaignChangeData;
import com.google.api.ads.adwords.axis.v201506.ch.CustomerSyncSelector;
import com.google.api.ads.adwords.axis.v201506.ch.CustomerSyncServiceInterface;
import com.google.api.ads.adwords.axis.v201506.cm.DateTimeRange;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Longs;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public final class CustomerSyncDelegate
extends AbstractBaseDelegate<CustomerSyncServiceInterface> {
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd hhmmss");

    public CustomerSyncDelegate(AdWordsSession adWordsSession) {
        super(adWordsSession, CustomerSyncServiceInterface.class);
    }

    @VisibleForTesting
    CustomerSyncDelegate(AdWordsSession adWordsSession, CustomerSyncServiceInterface service) {
        super(adWordsSession, service);
    }

    public List<CampaignChangeData> getCampaignChangeData(List<Long> campaignIds, Date dateStart, Date dateEnd) throws RemoteException {
        DateTimeRange dateTimeRange = new DateTimeRange();
        dateTimeRange.setMin(simpleDateFormat.format(dateStart));
        dateTimeRange.setMax(simpleDateFormat.format(dateEnd));
        CustomerSyncSelector customerSyncSelector = new CustomerSyncSelector();
        customerSyncSelector.setDateTimeRange(dateTimeRange);
        customerSyncSelector.setCampaignIds(Longs.toArray(campaignIds));
        return Arrays.asList(((CustomerSyncServiceInterface)this.getService()).get(customerSyncSelector).getChangedCampaigns());
    }

    public List<CampaignChangeData> getCampaignChangeData(Long campaignId, Date dateStart, Date dateEnd) throws RemoteException {
        return this.getCampaignChangeData((List<Long>)ImmutableList.of((Object)campaignId), dateStart, dateEnd);
    }
}

