/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.delegates;

import com.google.api.ads.adwords.axis.utility.extension.delegates.AbstractBaseDelegate;
import com.google.api.ads.adwords.axis.utility.extension.exception.UtilityLibraryException;
import com.google.api.ads.adwords.axis.v201506.cm.Address;
import com.google.api.ads.adwords.axis.v201506.cm.GeoLocation;
import com.google.api.ads.adwords.axis.v201506.cm.GeoLocationSelector;
import com.google.api.ads.adwords.axis.v201506.cm.GeoLocationServiceInterface;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.common.annotations.VisibleForTesting;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;

public final class GeoLocationDelegate
extends AbstractBaseDelegate<GeoLocationServiceInterface> {
    public GeoLocationDelegate(AdWordsSession adWordsSession) {
        super(adWordsSession, GeoLocationServiceInterface.class);
    }

    @VisibleForTesting
    GeoLocationDelegate(AdWordsSession adWordsSession, GeoLocationServiceInterface service) {
        super(adWordsSession, service);
    }

    public List<GeoLocation> getGeoLocation(List<Address> addresses) throws RemoteException {
        GeoLocationSelector geoLocationSelector = new GeoLocationSelector();
        geoLocationSelector.setAddresses(addresses.toArray(new Address[0]));
        return Arrays.asList(((GeoLocationServiceInterface)this.getService()).get(geoLocationSelector));
    }

    public GeoLocation getGeoLocation(Address address) throws RemoteException {
        GeoLocationSelector geoLocationSelector = new GeoLocationSelector();
        geoLocationSelector.setAddresses(new Address[]{address});
        GeoLocation[] array = ((GeoLocationServiceInterface)this.getService()).get(geoLocationSelector);
        if (array != null && array.length > 0) {
            return array[0];
        }
        throw new UtilityLibraryException("Error: result empty for getGeoLocation");
    }
}

