/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.delegates;

import com.google.api.ads.adwords.axis.utility.extension.delegates.AbstractGetDelegate;
import com.google.api.ads.adwords.axis.utility.extension.util.ListUtil;
import com.google.api.ads.adwords.axis.utility.extension.util.SelectorFields;
import com.google.api.ads.adwords.axis.v201506.cm.LocationCriterion;
import com.google.api.ads.adwords.axis.v201506.cm.LocationCriterionServiceInterface;
import com.google.api.ads.adwords.axis.v201506.cm.Selector;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.common.annotations.VisibleForTesting;
import java.rmi.RemoteException;
import java.util.List;

public final class LocationCriterionDelegate
extends AbstractGetDelegate<LocationCriterion, LocationCriterionServiceInterface> {
    public LocationCriterionDelegate(AdWordsSession adWordsSession) {
        super(adWordsSession, LocationCriterion.class, LocationCriterionServiceInterface.class, SelectorFields.LocationCriterion.all());
    }

    @VisibleForTesting
    LocationCriterionDelegate(AdWordsSession adWordsSession, LocationCriterionServiceInterface service) {
        super(adWordsSession, LocationCriterion.class, service, SelectorFields.LocationCriterion.all());
    }

    public LocationCriterionDelegate(AdWordsSession adWordsSession, List<SelectorFields.LocationCriterion> selectorFields) {
        super(adWordsSession, LocationCriterion.class, LocationCriterionServiceInterface.class, selectorFields);
    }

    @Override
    public List<LocationCriterion> get(Selector selector) throws RemoteException {
        LocationCriterion[] array = (LocationCriterion[])this.getPage(selector);
        return ListUtil.asList(array);
    }

    public LocationCriterion getById(Long locationCriterionId) throws RemoteException {
        return this.getOneByField(SelectorFields.LocationCriterion.ID, locationCriterionId);
    }

    public List<LocationCriterion> getById(List<Long> locationCriterionIds) throws RemoteException {
        return this.getByField(SelectorFields.LocationCriterion.ID, locationCriterionIds);
    }

    public List<LocationCriterion> getByLocationName(String locationName) throws RemoteException {
        return this.getByField(SelectorFields.LocationCriterion.LOCATION_NAME, locationName);
    }
}

