/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.delegates;

import com.google.api.ads.adwords.axis.utility.extension.delegates.AbstractGetMutateDelegate;
import com.google.api.ads.adwords.axis.utility.extension.util.ListUtil;
import com.google.api.ads.adwords.axis.utility.extension.util.SelectorFields;
import com.google.api.ads.adwords.axis.utils.v201506.SelectorBuilder;
import com.google.api.ads.adwords.axis.v201506.cm.ApiException;
import com.google.api.ads.adwords.axis.v201506.cm.Operator;
import com.google.api.ads.adwords.axis.v201506.mcm.LinkOperation;
import com.google.api.ads.adwords.axis.v201506.mcm.LinkStatus;
import com.google.api.ads.adwords.axis.v201506.mcm.ManagedCustomer;
import com.google.api.ads.adwords.axis.v201506.mcm.ManagedCustomerLink;
import com.google.api.ads.adwords.axis.v201506.mcm.ManagedCustomerOperation;
import com.google.api.ads.adwords.axis.v201506.mcm.ManagedCustomerServiceInterface;
import com.google.api.ads.adwords.axis.v201506.mcm.MoveOperation;
import com.google.api.ads.adwords.axis.v201506.mcm.MutateLinkResults;
import com.google.api.ads.adwords.axis.v201506.mcm.MutateManagerResults;
import com.google.api.ads.adwords.axis.v201506.mcm.PendingInvitation;
import com.google.api.ads.adwords.axis.v201506.mcm.PendingInvitationSelector;
import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.rmi.RemoteException;
import java.util.List;

public final class ManagedCustomerDelegate
extends AbstractGetMutateDelegate<ManagedCustomer, ManagedCustomerOperation, ManagedCustomerServiceInterface> {
    public ManagedCustomerDelegate(AdWordsSession adWordsSession) {
        super(adWordsSession, SelectorFields.ManagedCustomer.all(), ManagedCustomer.class, ManagedCustomerOperation.class, ManagedCustomerServiceInterface.class);
    }

    @VisibleForTesting
    ManagedCustomerDelegate(AdWordsSession adWordsSession, ManagedCustomerServiceInterface service) {
        super(adWordsSession, SelectorFields.ManagedCustomer.all(), ManagedCustomer.class, ManagedCustomerOperation.class, service);
    }

    public ManagedCustomerDelegate(AdWordsSession adWordsSession, List<SelectorFields.ManagedCustomer> selectorFields) {
        super(adWordsSession, selectorFields, ManagedCustomer.class, ManagedCustomerOperation.class, ManagedCustomerServiceInterface.class);
    }

    public List<ManagedCustomer> getByCustomerId(List<Long> customerIds) throws RemoteException {
        return this.getByField(SelectorFields.ManagedCustomer.CUSTOMER_ID, customerIds);
    }

    public ManagedCustomer getByCustomerId(Long customerId) throws RemoteException {
        return this.getByCustomerId(String.valueOf(customerId));
    }

    public ManagedCustomer getByCustomerId(String customerId) throws RemoteException {
        Preconditions.checkNotNull((Object)customerId, (Object)"Null customer ID");
        String customerIdWithoutDashes = customerId.replace("-", "");
        return this.getOneByField(SelectorFields.ManagedCustomer.CUSTOMER_ID, Long.valueOf(customerIdWithoutDashes));
    }

    public List<ManagedCustomer> getByCanManageClients(boolean canManageClients) throws RemoteException {
        return this.getByField(SelectorFields.ManagedCustomer.CAN_MANAGE_CLIENTS, canManageClients);
    }

    public List<ManagedCustomer> getByCustomerIdCanManageClients(List<Long> customerIds, boolean canManageClients) throws RemoteException {
        SelectorBuilder builder = this.createSelectorBuilder();
        if (customerIds != null && !customerIds.isEmpty()) {
            builder.in(SelectorFields.ManagedCustomer.CUSTOMER_ID.getField(), ListUtil.asStringArray(customerIds));
        }
        builder.equals(SelectorFields.ManagedCustomer.CAN_MANAGE_CLIENTS.getField(), String.valueOf(canManageClients));
        return this.get(builder.build());
    }

    public List<PendingInvitation> getPendingInvitations(PendingInvitationSelector selector) throws ApiException, RemoteException {
        return ListUtil.asList(((ManagedCustomerServiceInterface)this.getService()).getPendingInvitations(selector));
    }

    public List<PendingInvitation> getPendingInvitations() throws ApiException, RemoteException {
        return ListUtil.asList(((ManagedCustomerServiceInterface)this.getService()).getPendingInvitations(new PendingInvitationSelector()));
    }

    public MutateLinkResults mutateLink(LinkOperation[] operations) throws ApiException, RemoteException {
        return ((ManagedCustomerServiceInterface)this.getService()).mutateLink(operations);
    }

    public List<ManagedCustomerLink> invitationExtend(List<ManagedCustomerLink> managedCustomerLinks) throws ApiException, RemoteException {
        LinkOperation[] listOperations = new LinkOperation[managedCustomerLinks.size()];
        for (int i = 0; i < managedCustomerLinks.size(); ++i) {
            managedCustomerLinks.get(i).setLinkStatus(LinkStatus.PENDING);
            listOperations[i] = new LinkOperation(Operator.ADD, null, managedCustomerLinks.get(i));
        }
        return ListUtil.asList(((ManagedCustomerServiceInterface)this.getService()).mutateLink(listOperations).getLinks());
    }

    public List<ManagedCustomerLink> invitationRescind(List<ManagedCustomerLink> managedCustomerLinks) throws ApiException, RemoteException {
        LinkOperation[] listOperations = new LinkOperation[managedCustomerLinks.size()];
        for (int i = 0; i < managedCustomerLinks.size(); ++i) {
            managedCustomerLinks.get(i).setLinkStatus(LinkStatus.CANCELLED);
            listOperations[i] = new LinkOperation(Operator.SET, null, managedCustomerLinks.get(i));
        }
        return ListUtil.asList(((ManagedCustomerServiceInterface)this.getService()).mutateLink(listOperations).getLinks());
    }

    public List<ManagedCustomerLink> invitationAccept(List<ManagedCustomerLink> managedCustomerLinks) throws ApiException, RemoteException {
        LinkOperation[] listOperations = new LinkOperation[managedCustomerLinks.size()];
        for (int i = 0; i < managedCustomerLinks.size(); ++i) {
            managedCustomerLinks.get(i).setLinkStatus(LinkStatus.ACTIVE);
            listOperations[i] = new LinkOperation(Operator.SET, null, managedCustomerLinks.get(i));
        }
        return ListUtil.asList(((ManagedCustomerServiceInterface)this.getService()).mutateLink(listOperations).getLinks());
    }

    public List<ManagedCustomerLink> invitationDecline(List<ManagedCustomerLink> managedCustomerLinks) throws ApiException, RemoteException {
        LinkOperation[] listOperations = new LinkOperation[managedCustomerLinks.size()];
        for (int i = 0; i < managedCustomerLinks.size(); ++i) {
            managedCustomerLinks.get(i).setLinkStatus(LinkStatus.REFUSED);
            listOperations[i] = new LinkOperation(Operator.SET, null, managedCustomerLinks.get(i));
        }
        return ListUtil.asList(((ManagedCustomerServiceInterface)this.getService()).mutateLink(listOperations).getLinks());
    }

    public List<ManagedCustomerLink> terminateLink(List<ManagedCustomerLink> managedCustomerLinks) throws ApiException, RemoteException {
        LinkOperation[] listOperations = new LinkOperation[managedCustomerLinks.size()];
        for (int i = 0; i < managedCustomerLinks.size(); ++i) {
            managedCustomerLinks.get(i).setLinkStatus(LinkStatus.INACTIVE);
            listOperations[i] = new LinkOperation(Operator.SET, null, managedCustomerLinks.get(i));
        }
        return ListUtil.asList(((ManagedCustomerServiceInterface)this.getService()).mutateLink(listOperations).getLinks());
    }

    public MutateManagerResults mutateManager(MoveOperation[] operations) throws ApiException, RemoteException {
        return ((ManagedCustomerServiceInterface)this.getService()).mutateManager(operations);
    }

    public List<ManagedCustomerLink> moveManager(List<ManagedCustomerLink> managedCustomerLinks, Long oldManagerCustomerId) throws ApiException, RemoteException {
        MoveOperation[] listOperations = new MoveOperation[managedCustomerLinks.size()];
        for (int i = 0; i < managedCustomerLinks.size(); ++i) {
            managedCustomerLinks.get(i).setLinkStatus(LinkStatus.ACTIVE);
            listOperations[i] = new MoveOperation(Operator.SET, null, managedCustomerLinks.get(i), oldManagerCustomerId);
        }
        return ListUtil.asList(((ManagedCustomerServiceInterface)this.getService()).mutateManager(listOperations).getLinks());
    }
}

