/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.util;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.client.reporting.ReportingConfiguration;
import com.google.api.ads.common.lib.auth.OfflineCredentials;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.OAuthException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.client.auth.oauth2.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdWordsSessionUtil {
    static Logger log = LoggerFactory.getLogger(AdWordsSessionUtil.class);
    private static final String USER_AGENT = "AdWordsAxisUtilityExtension";

    public static AdWordsSession copy(AdWordsSession adWordsSession) {
        return AdWordsSessionUtil.copy(adWordsSession, adWordsSession.getUserAgent());
    }

    public static AdWordsSession copyWithUtilityUserAgent(AdWordsSession adWordsSession) {
        String userAgent = "";
        if (adWordsSession.getUserAgent() != null) {
            userAgent = adWordsSession.getUserAgent();
        }
        if (!userAgent.startsWith(USER_AGENT)) {
            String string = String.valueOf(USER_AGENT);
            String string2 = String.valueOf(userAgent);
            return AdWordsSessionUtil.copy(adWordsSession, string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        return AdWordsSessionUtil.copy(adWordsSession);
    }

    public static AdWordsSession copyIfNeededWithUtilityUserAgent(AdWordsSession adWordsSession) {
        String userAgent = "";
        if (adWordsSession.getUserAgent() != null) {
            userAgent = adWordsSession.getUserAgent();
        }
        if (!userAgent.startsWith(USER_AGENT)) {
            String string = String.valueOf(USER_AGENT);
            String string2 = String.valueOf(userAgent);
            return AdWordsSessionUtil.copy(adWordsSession, string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        return adWordsSession;
    }

    public static AdWordsSession copy(AdWordsSession adWordsSession, String userAgent) {
        AdWordsSession.Builder builder = new AdWordsSession.Builder();
        if (adWordsSession.getEndpoint() != null) {
            builder = builder.withEndpoint(adWordsSession.getEndpoint());
        }
        builder = userAgent != null ? builder.withUserAgent(userAgent) : builder.withUserAgent(USER_AGENT);
        if (adWordsSession.getDeveloperToken() != null) {
            builder = builder.withDeveloperToken(adWordsSession.getDeveloperToken());
        }
        if (adWordsSession.getClientCustomerId() != null) {
            builder = builder.withClientCustomerId(adWordsSession.getClientCustomerId());
        }
        if (adWordsSession.getOAuth2Credential() != null) {
            builder = builder.withOAuth2Credential(adWordsSession.getOAuth2Credential());
        }
        if (adWordsSession.getReportingConfiguration() != null) {
            ReportingConfiguration reportingConfig = new ReportingConfiguration.Builder().skipReportHeader(adWordsSession.getReportingConfiguration().isSkipReportHeader()).skipColumnHeader(adWordsSession.getReportingConfiguration().isSkipColumnHeader()).skipReportSummary(adWordsSession.getReportingConfiguration().isSkipReportSummary()).includeZeroImpressions(adWordsSession.getReportingConfiguration().isIncludeZeroImpressions()).build();
            builder = builder.withReportingConfiguration(reportingConfig);
        }
        try {
            AdWordsSession newAdWordsSession = builder.build();
            newAdWordsSession.setPartialFailure(adWordsSession.isPartialFailure());
            newAdWordsSession.setValidateOnly(adWordsSession.isValidateOnly());
            return newAdWordsSession;
        }
        catch (ValidationException e) {
            log.warn("Error @addUtilityUserAgent, returning unchanged AdWordsSession");
            return adWordsSession;
        }
    }

    public static AdWordsSession fromFileWithOAuth2() throws OAuthException, ValidationException, ConfigurationLoadException {
        Credential oAuth2Credential = new OfflineCredentials.Builder().forApi(OfflineCredentials.Api.ADWORDS).fromFile().build().generateCredential();
        return new AdWordsSession.Builder().fromFile().withOAuth2Credential(oAuth2Credential).build();
    }
}

