/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utility.extension.util;

import com.google.api.ads.adwords.axis.utility.extension.exception.UtilityLibraryException;
import com.google.api.ads.adwords.axis.v201506.cm.ApiError;
import com.google.api.ads.adwords.axis.v201506.cm.ApiException;
import com.google.api.ads.adwords.axis.v201506.cm.InternalApiError;
import com.google.api.ads.adwords.axis.v201506.cm.RateExceededError;
import com.google.common.collect.Maps;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    static Logger log = LoggerFactory.getLogger(ReflectionUtil.class);
    private static HashMap<String, Method> methodsCache = Maps.newHashMap();

    public static Object invokeCount(String methodName, Object obj, Class<?> objClass, int invokeMaxCount) throws RemoteException {
        return ReflectionUtil.invokeCount(methodName, obj, objClass, null, null, invokeMaxCount);
    }

    public static Object invokeCount(String methodName, Object obj, Class<?> objClass, Object args, int invokeMaxCount) throws RemoteException {
        return ReflectionUtil.invokeCount(methodName, obj, objClass, args, args.getClass(), invokeMaxCount);
    }

    public static Object invokeCount(String methodName, Object obj, Class<?> objClass, Object args, Class<?> argsClass, int invokeMaxCount) throws RemoteException {
        String className = obj == null ? objClass.getCanonicalName() : obj.getClass().getCanonicalName();
        if (objClass != null) {
            className = objClass.getCanonicalName();
        } else {
            objClass = obj.getClass();
        }
        String string = className;
        RemoteException remoteException = new RemoteException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(methodName).length()).append("Error during reflection for ").append(string).append(".").append(methodName).toString());
        int invokeCount = 0;
        Boolean retry = true;
        while (retry.booleanValue() && invokeCount < invokeMaxCount) {
            String string2;
            retry = false;
            ++invokeCount;
            try {
                Method method;
                if (args != null) {
                    Method method2;
                    String string3 = className;
                    string2 = String.valueOf(argsClass.getCanonicalName());
                    if (methodsCache.containsKey(new StringBuilder(0 + String.valueOf(string3).length() + String.valueOf(methodName).length() + String.valueOf(string2).length()).append(string3).append(methodName).append(string2).toString())) {
                        string3 = className;
                        string2 = String.valueOf(argsClass.getCanonicalName());
                        method2 = methodsCache.get(new StringBuilder(0 + String.valueOf(string3).length() + String.valueOf(methodName).length() + String.valueOf(string2).length()).append(string3).append(methodName).append(string2).toString());
                    } else {
                        method2 = objClass.getMethod(methodName, argsClass);
                        string3 = String.valueOf(objClass.getCanonicalName());
                        string2 = String.valueOf(argsClass.getCanonicalName());
                        methodsCache.put(new StringBuilder(0 + String.valueOf(string3).length() + String.valueOf(methodName).length() + String.valueOf(string2).length()).append(string3).append(methodName).append(string2).toString(), method2);
                    }
                    return method2.invoke(obj, args);
                }
                String string4 = String.valueOf(obj.getClass().getCanonicalName());
                String string5 = String.valueOf(methodName);
                if (methodsCache.containsKey(string5.length() != 0 ? string4.concat(string5) : new String(string4))) {
                    String string6 = String.valueOf(obj.getClass().getCanonicalName());
                    String string7 = String.valueOf(methodName);
                    method = methodsCache.get(string7.length() != 0 ? string6.concat(string7) : new String(string6));
                } else {
                    method = obj.getClass().getMethod(methodName, new Class[0]);
                    String string8 = String.valueOf(obj.getClass().getCanonicalName());
                    String string9 = String.valueOf(methodName);
                    methodsCache.put(string9.length() != 0 ? string8.concat(string9) : new String(string8), method);
                }
                return method.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                ApiError[] errorArray;
                string2 = className;
                remoteException = UtilityLibraryException.getUnwrapApiExceptions(e, new StringBuilder(29 + String.valueOf(string2).length() + String.valueOf(methodName).length()).append("Error during reflection for ").append(string2).append(".").append(methodName).toString());
                Throwable cause = remoteException.getCause();
                if (cause != null && (cause.getClass().isAssignableFrom(SocketException.class) || cause.getClass().isAssignableFrom(InterruptedIOException.class) || cause.getClass().isAssignableFrom(ConnectException.class))) {
                    retry = true;
                    String string10 = className;
                    int n = invokeCount;
                    log.warn(new StringBuilder(75 + String.valueOf(string10).length() + String.valueOf(methodName).length()).append("SocketException error, retrying last operation: ").append(string10).append(".").append(methodName).append(" (").append(n).append("/").append(invokeMaxCount).append(")").toString());
                    continue;
                }
                if (!remoteException.getClass().equals(ApiException.class)) continue;
                ApiException apiException = (ApiException)remoteException;
                for (ApiError apiError : errorArray = apiException.getErrors()) {
                    if (apiError instanceof RateExceededError) {
                        retry = true;
                        try {
                            int seconds = ((RateExceededError)apiError).getRetryAfterSeconds();
                            String string11 = className;
                            int n = invokeCount;
                            log.warn(new StringBuilder(106 + String.valueOf(string11).length() + String.valueOf(methodName).length()).append("RateExceededError error, retrying last operation: ").append(string11).append(".").append(methodName).append(" (").append(n).append("/").append(invokeMaxCount).append(")").append(" waiting seconds: ").append(seconds).toString());
                            Thread.sleep(seconds * 1000);
                        }
                        catch (InterruptedException interruptedException) {
                            throw remoteException;
                        }
                    }
                    if (!(apiError instanceof InternalApiError)) continue;
                    retry = true;
                    String string12 = className;
                    int n = invokeCount;
                    log.warn(new StringBuilder(76 + String.valueOf(string12).length() + String.valueOf(methodName).length()).append("InternalApiError error, retrying last operation: ").append(string12).append(".").append(methodName).append(" (").append(n).append("/").append(invokeMaxCount).append(")").toString());
                }
            }
        }
        throw remoteException;
    }
}

