/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfa.axis.utils;

import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.dfa.lib.auth.LoginTokensHelper;
import com.google.api.ads.dfa.lib.client.DfaSession;
import com.google.api.ads.dfa.lib.factory.DfaServiceClientFactory;
import com.google.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfaAxisLoginTokensHelper
implements LoginTokensHelper {
    private final DfaServiceClientFactory dfaServiceClientFactory;

    @Inject
    public DfaAxisLoginTokensHelper(DfaServiceClientFactory dfaServiceClientFactory) {
        this.dfaServiceClientFactory = dfaServiceClientFactory;
    }

    public Class<?> getLoginClass(String stubPackage) throws ClassNotFoundException {
        return Class.forName(String.valueOf(stubPackage) + ".LoginRemote");
    }

    public Class<?> getUserProfileClass(String stubPackage) throws ClassNotFoundException {
        return Class.forName(String.valueOf(stubPackage) + ".UserProfile");
    }

    public Object getLoginService(DfaSession session, Class<?> loginClass) {
        return this.dfaServiceClientFactory.getServiceClientAsInterface((AdsSession)session, loginClass);
    }

    public Object authenticate(String username, String password, Class<?> loginClass, Object loginService) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class[] paramTypes = new Class[]{String.class, String.class};
        Method authMethod = loginClass.getDeclaredMethod("authenticate", paramTypes);
        Object[] argList = new Object[]{username, password};
        return authMethod.invoke(loginService, argList);
    }

    public String retrieveToken(Object userProfile) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Class[] paramTypes = new Class[]{};
        Object[] argList = new Object[]{};
        Method getToken = userProfile.getClass().getMethod("getToken", paramTypes);
        return (String)getToken.invoke(userProfile, argList);
    }
}

