/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfa.axis.utils;

import com.google.api.ads.dfa.lib.auth.TokenExpirationDetector;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import org.apache.axis.AxisFault;

public class DfaAxisTokenExpirationDetector
implements TokenExpirationDetector {
    @VisibleForTesting
    protected static final long TOKEN_EXPIRED_CODE = 4L;
    @VisibleForTesting
    protected static final String TOKEN_EXPIRED_MESSAGE = "Authentication token has expired.";

    public boolean isTokenExpiredException(@Nullable Throwable exception) {
        if (exception instanceof AxisFault) {
            Object errorMessage;
            Object errorCode;
            try {
                errorCode = exception.getClass().getMethod("getErrorCode", new Class[0]).invoke((Object)exception, new Object[0]);
                errorMessage = exception.getClass().getMethod("getErrorMessage", new Class[0]).invoke((Object)exception, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            catch (SecurityException securityException) {
                return false;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
            catch (InvocationTargetException invocationTargetException) {
                return false;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return false;
            }
            return errorCode.equals(4L) && errorMessage.equals(TOKEN_EXPIRED_MESSAGE);
        }
        return false;
    }
}

